<?php
declare(strict_types=1);

use Migrations\AbstractSeed;

class ContentBlocksSeed extends AbstractSeed
{
    public function run(): void
    {
        $data = [
            [
                'parent' => 'global',
                'label' => 'Website Logo',
                'description' => 'Upload your website logo.',
                'slug' => 'website-logo',
                'type' => 'image',
            ],
            [
                'parent' => 'global',
                'label' => 'Website Name',
                'description' => 'Enter your website name.',
                'slug' => 'website-name',
                'type' => 'text',
                'value' => 'My Portfolio',
            ],
            [
                'parent' => 'home',
                'label' => 'Landing Page Content 1',
                'description' => 'First section of landing page content.',
                'slug' => 'landing-page-content-1',
                'type' => 'html',
                'value' => '<p>Welcome to my portfolio!</p>',
            ],
            [
                'parent' => 'home',
                'label' => 'Landing Page Content 2',
                'description' => 'Second section of landing page content.',
                'slug' => 'landing-page-content-2',
                'type' => 'html',
                'value' => '<p>Welcome to my portfolio!</p>',
            ],
            [
                'parent' => 'home',
                'label' => 'About Me Title',
                'description' => 'Title of the About Me section.',
                'slug' => 'about-me-title',
                'type' => 'html',
                'value' => 'About Me',
            ],
            [
                'parent' => 'global',
                'label' => 'About Me Name',
                'description' => 'Name displayed in the About Me section.',
                'slug' => 'about-me-name',
                'type' => 'html',
                'value' => 'John Doe',
            ],
            [
                'parent' => 'global',
                'label' => 'Phone',
                'description' => 'Contact phone number.',
                'slug' => 'phone',
                'type' => 'html',
                'value' => '+123 456 7890',
            ],
            [
                'parent' => 'home',
                'label' => 'About Me Age',
                'description' => 'Age displayed in the About Me section.',
                'slug' => 'about-me-age',
                'type' => 'text',
                'value' => '30',
            ],
            [
                'parent' => 'global',
                'label' => 'Email',
                'description' => 'Email address.',
                'slug' => 'email',
                'type' => 'html',
                'value' => 'email@example.com',
            ],
            [
                'parent' => 'home',
                'label' => 'Occupation',
                'description' => 'Occupation or job title.',
                'slug' => 'occupation',
                'type' => 'html',
                'value' => 'Software Engineer',
            ],
            [
                'parent' => 'home',
                'label' => 'Nationality',
                'description' => 'Nationality information.',
                'slug' => 'nationality',
                'type' => 'text',
                'value' => 'Australian',
            ],
            [
                'parent' => 'home',
                'label' => 'Signature',
                'description' => 'Upload your signature',
                'slug' => 'signature',
                'type' => 'image',
            ],
            [
                'parent' => 'home',
                'label' => 'Job Title',
                'description' => 'Current job title.',
                'slug' => 'job-title',
                'type' => 'text',
                'value' => 'Senior Developer',
            ],
            [
                'parent' => 'home',
                'label' => 'Picture Themselves',
                'description' => 'Profile picture for the About Me section.',
                'slug' => 'picture-themselves',
                'type' => 'image',
            ],
            [
                'parent' => 'home',
                'label' => 'Address',
                'description' => 'Please put ur address here',
                'slug' => 'address',
                'type' => 'html',
                'value' => 'Wellington Rd, Clayton VIC 3800',
            ],

        ];
        
        $data[] = [
            'parent' => 'home',
            'label' => 'Science Description',
            'description' => 'Description text for Science section.',
            'slug' => 'science-description',
            'type' => 'html',
            'value' => 'We use science as a tool to help our students understand the world around us, with our current focus being on environmental sciences, in topics such as food waste, global warming, climate change and plastic waste. Our students and mentors work through science and other STEM subject areas in our programs.',
        ];
        
        $data[] = [
            'parent' => 'home',
            'label' => 'Technology Description',
            'description' => 'Description text for Technology section.',
            'slug' => 'technology-description',
            'type' => 'html',
            'value' => 'One of the main topics that we educate our students in is technology. We do this through coding, robotics, artificial intelligence and so much more. Technology is embedded in many of our programs, such as FIRST Lego League, The IBM AI Project and our app development project for Kingston Council, and we hope to continue teaching through technology as it is an extremely important skill for future generations.',
        ];
        
        $data[] = [
            'parent' => 'home',
            'label' => 'Engineering Description',
            'description' => 'Description text for Engineering section.',
            'slug' => 'engineering-description',
            'type' => 'html',
            'value' => 'Engineering is a vital concept that kids need to understand to combat real-world scenarios. The focus on core elements of Engineering in the day-to-day tasks and the projects is something kids have to be aware of and we focus on bringing value. FIRST Lego League, amongst many other programs, entails engineering, as participants are required to use their skills to construct a suitable robot and accessories, corresponding with the missions it needs to complete.',
        ];
        
        $data[] = [
            'parent' => 'home',
            'label' => 'Mathematics Description',
            'description' => 'Description text for Mathematics section.',
            'slug' => 'mathematics-description',
            'type' => 'html',
            'value' => 'We teach mathematics both directly, and indirectly, by educating students in mathematical concepts, and through problem-solving in a multitude of activities. In 2021, the students partook in the Australian Mathematics Competition, which is a competitive mathematics examination held annually, giving the participants a ranking of how they stand against their peers. With extensive coaching given by our mentors, the participants achieved remarkable scores.',
        ];
        

$data[] = [
    'parent' => 'home',
    'label' => 'Explore Program 2025 Description',
    'description' => 'Description for Explore - Our Program 2025 section.',
    'slug' => 'explore-program-2025-description',
    'type' => 'html',
    'value' => 'In 2025, STEM Incubator will be running classes for Year 7 and 8 students who wish to gain entry into a Selective Entrance High School (SEHS) in 2025 or 2026 respectively. We have been running this program for 4 years, and have had success rates of 71% and 100%.',
];

$data[] = [
    'parent' => 'home',
    'label' => 'Explore Program 2025 Features',
    'description' => 'Bullet points for Explore - Our Program 2025 features.',
    'slug' => 'explore-program-2025-features',
    'type' => 'html',
    'value' => '<ul>
<li>How will our classes help?</li>
<li>Introduce key topics early and go in-depth into them, to give students a comprehensive understanding so they can implement skills and concepts for the exam.</li>
<li>Some tips and tricks to apply for the exam.</li>
<li>Concepts and methods that will appear on the exam are covered in detail.</li>
<li>Extension questions to improve student understanding.</li>
<li>More student-oriented, focused on what THEY want to learn.</li>
<li>Teachers have first-hand experience with the exam and can offer valuable advice.</li>
</ul>',
];

$data[] = [
    'parent' => 'home',
    'label' => 'Our Teachers Section',
    'description' => 'List of teachers and their descriptions.',
    'slug' => 'our-teachers',
    'type' => 'html',
    'value' => '<ul>
<li>Rehaan Saili: Strong in selective exam preparation and mathematics, leading Year 7 classes.</li>
<li>Sri Karithikeyan: High-achieving student with STEM background, leading Year 7 classes.</li>
<li>Vishnu Esawar: Former Melbourne High student, now teaching Year 8 with student-centric strategies.</li>
<li>Iasaan Ahmed Sambaniyah: Engaging, effective in breaking down academic content for Year 8s.</li>
<li>Zaina Saili: Year 9 Mac.Rob student with a passion for teaching and strong support for Year 7 & 8s.</li>
</ul>',
];

$data[] = [
    'parent' => 'home',
    'label' => 'Year 7 Program Description',
    'description' => 'Description for the Year 7 program.',
    'slug' => 'year-7-program-description',
    'type' => 'html',
    'value' => 'An introduction for students to familiarise and practise key concepts. In order to best prepare for success in the SEHS Exam, the program covers concepts that extend out to late years of high school and begin introducing students to the test styles they can expect to see.',
];

$data[] = [
    'parent' => 'home',
    'label' => 'Year 8 Program Description',
    'description' => 'Description for the Year 8 program.',
    'slug' => 'year-8-program-description',
    'type' => 'html',
    'value' => 'The Year 8 tutoring program focuses on Victorian selective entrance exam preparation through weekly practice exams and targeted review. We identify student weak areas from test results and provide extra support to those topics, while reinforcing core Year 8 concepts they need to master. This ensures students improve both their test performance and overall understanding.',
];

$data[] = [
    'parent' => 'home',
    'label' => 'Explore Program 2025 Description',
    'description' => 'Description for Explore - Our Program 2025 section.',
    'slug' => 'explore-program-2025-description',
    'type' => 'html',
    'value' => 'In 2025, STEM Incubator will be running classes for Year 7 and 8 students who wish to gain entry into a Selective Entrance High School (SEHS) in 2025 or 2026 respectively. We have been running this program for 4 years, and have had success rates of 71% and 100%.',
];

$data[] = [
    'parent' => 'home',
    'label' => 'Explore Program 2025 Features',
    'description' => 'Bullet points for Explore - Our Program 2025 features.',
    'slug' => 'explore-program-2025-features',
    'type' => 'html',
    'value' => '<ul>
<li>How will our classes help?</li>
<li>Introduce key topics early and go in-depth into them, to give students a comprehensive understanding so they can implement skills and concepts for the exam.</li>
<li>Some tips and tricks to apply for the exam.</li>
<li>Concepts and methods that will appear on the exam are covered in detail.</li>
<li>Extension questions to improve student understanding.</li>
<li>More student-oriented, focused on what THEY want to learn.</li>
<li>Teachers have first-hand experience with the exam and can offer valuable advice.</li>
</ul>',
];

$data[] = [
    'parent' => 'home',
    'label' => 'Our Teachers Section',
    'description' => 'List of teachers and their descriptions.',
    'slug' => 'our-teachers',
    'type' => 'html',
    'value' => '<ul>
<li>Rehaan Saili: Strong in selective exam preparation and mathematics, leading Year 7 classes.</li>
<li>Sri Karithikeyan: High-achieving student with STEM background, leading Year 7 classes.</li>
<li>Vishnu Esawar: Former Melbourne High student, now teaching Year 8 with student-centric strategies.</li>
<li>Iasaan Ahmed Sambaniyah: Engaging, effective in breaking down academic content for Year 8s.</li>
<li>Zaina Saili: Year 9 Mac.Rob student with a passion for teaching and strong support for Year 7 & 8s.</li>
</ul>',
];

$data[] = [
    'parent' => 'home',
    'label' => 'Year 7 Program Description',
    'description' => 'Description for the Year 7 program.',
    'slug' => 'year-7-program-description',
    'type' => 'html',
    'value' => 'An introduction for students to familiarise and practise key concepts. In order to best prepare for success in the SEHS Exam, the program covers concepts that extend out to late years of high school and begin introducing students to the test styles they can expect to see.',
];

$data[] = [
    'parent' => 'home',
    'label' => 'Year 8 Program Description',
    'description' => 'Description for the Year 8 program.',
    'slug' => 'year-8-program-description',
    'type' => 'html',
    'value' => 'The Year 8 tutoring program focuses on Victorian selective entrance exam preparation through weekly practice exams and targeted review. We identify student weak areas from test results and provide extra support to those topics, while reinforcing core Year 8 concepts they need to master. This ensures students improve both their test performance and overall understanding.',
];

$data[] = [
    'parent' => 'home',
    'label' => 'Year 7 Program - What We Do',
    'description' => 'Bullet points describing what the program offers.',
    'slug' => 'year-7-program-what-we-do',
    'type' => 'html',
    'value' => '<ul>
<li>Assurance that the student understands the topic fully.</li>
<li>Recordings if the student missed class, or wants to review.</li>
<li>Weekly worksheets to strengthen understanding of concepts.</li>
<li>Regular topic tests to gauge performance.</li>
<li>Additional help on request outside of class.</li>
<li>Review documents after every class, summarising what has been covered.</li>
</ul>',
];

$data[] = [
    'parent' => 'home',
    'label' => 'Year 7 Program - Class Structure',
    'description' => 'Details of the class structure.',
    'slug' => 'year-7-program-class-structure',
    'type' => 'html',
    'value' => '<p>Online Classes (1.5 hours, once a week)</p>
<ol>
<li>A quick recap of the previous class. (10 mins)</li>
<li>Main concept covered and practice questions. (60 mins)</li>
<li>Doubt clearing for the main concept. (10 mins)</li>
<li>Worksheet review and Q&amp;A. (15 mins)</li>
</ol>',
];

$data[] = [
    'parent' => 'home',
    'label' => 'Year 7 Program - Content Topics',
    'description' => 'Mathematics topics covered in the program.',
    'slug' => 'year-7-program-content-topics',
    'type' => 'html',
    'value' => '<ul>
<li><strong>Algebra:</strong> Brackets, tips/tricks, inequalities</li>
<li><strong>Linear Equations &amp; Graphs:</strong> Interpreting, graphing, simultaneous equations</li>
<li><strong>Indices and Surds:</strong> Index laws, simplification</li>
<li><strong>Ratios and Proportions:</strong> Time problems, scaling</li>
<li><strong>Probability and Statistics:</strong> Venn diagrams, IQR, mean/median/mode</li>
<li><strong>Counting Principles:</strong> Combinations, permutations</li>
<li><strong>Geometry:</strong> Trigonometry, surface area, angles</li>
<li><strong>Quadratics:</strong> Solving, deriving, graphing</li>
<li><strong>Numerical Reasoning:</strong> Financial maths, patterns, word problems</li>
</ul>',
];


$data[] = [
    'parent' => 'home',
    'label' => 'Year 7 Program - Payment Terms',
    'description' => 'Payment terms and conditions for the program.',
    'slug' => 'year-7-program-payment-terms',
    'type' => 'html',
    'value' => '<p>The Standard Pricing for the Year 7 Program is $30 per week, billed monthly.</p><p>For Terms and Conditions, visit here:</p>',
];

$data[] = [
    'parent' => 'home',
    'label' => 'Year 8 Program - What We Do',
    'description' => 'Bullet points describing what the Year 8 program offers.',
    'slug' => 'year-8-program-what-we-do',
    'type' => 'html',
    'value' => '<ul>
<li>Assurance that the student understands the topic fully.</li>
<li>Recordings if the student missed class, or wants to review.</li>
<li>Weekly worksheets to strengthen understanding of concepts.</li>
<li>Regular topic tests to gauge performance.</li>
<li>Additional help on request outside of class.</li>
<li>Review documents after every class, summarising what has been covered.</li>
</ul>',
];

$data[] = [
    'parent' => 'home',
    'label' => 'Year 8 Program - Class Structure',
    'description' => 'Details of the class structure for the Year 8 program.',
    'slug' => 'year-8-program-class-structure',
    'type' => 'html',
    'value' => '<p>Online Classes (1 hour classes, twice a week)</p>
<p><strong>Class 1</strong></p>
<ol>
<li>Setup for exam (5 mins)</li>
<li>Practice exam during class - Mathematics, and once every 3 weeks Quantitative Reasoning (40 mins)</li>
<li>Questions and exam feedback (15 mins)</li>
</ol>
<p><strong>Class 2</strong></p>
<ol>
<li>Review of exam questions (30 - 40 mins)</li>
<li>Review of any weak topics students may want to cover (20 - 30 mins)</li>
</ol>',
];

$data[] = [
    'parent' => 'home',
    'label' => 'Year 8 Program - Content Topics',
    'description' => 'Mathematics topics covered in the Year 8 program.',
    'slug' => 'year-8-program-content-topics',
    'type' => 'html',
    'value' => '<p>The Year 8 program is much more test oriented, aiming to best prepare students for the tests in the upcoming year. These tests were carefully curated after thoroughly analysing the new ACER test format, and aims to provide the most suitable content for student preparation.</p>
<p><strong>Mathematics Topics</strong></p>
<ul>
<li><strong>Algebra:</strong>
<ul>
<li>Basic Algebra: Solving, expanding, and simplifying brackets</li>
<li>Extended Algebra: Tips/tricks, difference of perfect squares, inequalities</li>
</ul>
</li>
<li><strong>Linear Equations and Graphs:</strong>
<ul>
<li>Solving and interpreting linear equations</li>
<li>Graphing linear equations: Distance, midpoint, and intersection</li>
<li>Simultaneous equations: Elimination, substitution, and three equations</li>
</ul>
</li>
<li><strong>Indices and Surds:</strong>
<ul>
<li>Index laws</li>
<li>Surds: Simplification, arithmetic operations, rationalising</li>
</ul>
</li>
<li><strong>Ratios and Proportions:</strong>
<ul>
<li>Ratios: Simplifying, splitting, and work-time problems</li>
</ul>
</li>
<li><strong>Probability and Statistics:</strong>
<ul>
<li>Probability: Venn diagrams, tree diagrams, fractions</li>
<li>Statistics: IQR, mean, median, mode, range</li>
</ul>
</li>
<li><strong>Counting Principles:</strong>
<ul>
<li>Methods: Box method, combinations, permutations</li>
</ul>
</li>
<li><strong>Geometry and Measurement:</strong>
<ul>
<li>Triangles: Pythagoras theorem</li>
<li>Trigonometry: Trigonometric ratios and tables</li>
<li>Surface area and volume: Basic and complex shapes</li>
<li>Geometry: Angles, shapes, parallel and perpendicular lines</li>
<li>Circle geometry</li>
</ul>
</li>
<li><strong>Quadratics:</strong>
<ul>
<li>Solving and factorising quadratic equations</li>
<li>Deriving information from quadratic equations</li>
<li>Graphing quadratics</li>
</ul>
</li>
<li><strong>Numerical Reasoning:</strong>
<ul>
<li>Financial mathematics</li>
<li>Patterns</li>
<li>Worked questions</li>
</ul>
</li>
</ul>',
];

$data[] = [
    'parent' => 'home',
    'label' => 'Year 8 Program - Payment Terms',
    'description' => 'Payment terms and conditions for the Year 8 program.',
    'slug' => 'year-8-program-payment-terms',
    'type' => 'html',
    'value' => '<p>The Standard Pricing for the Year 8 Program is $40 per week, billed monthly.</p><p>For Terms and Conditions, visit here:</p>',
];



        $table = $this->table('content_blocks');
        $table->insert($data)->save();
    }
}