<?php
declare(strict_types=1);

namespace App\Controller;

use App\Mailer\EnquiryMailer;
use App\Model\Table\EnquiriesTable;
use Cake\Core\Configure;
use Cake\Http\Exception\ForbiddenException;
use Cake\Http\Exception\NotFoundException;
use Cake\Http\Response;
use Cake\Mailer\Mailer;
use Cake\View\Exception\MissingTemplateException;
use Cake\ORM\TableRegistry;

class PagesController extends AppController
{
    /**
     * Displays a view
     *
     * @param string ...$path Path segments.
     * @return \Cake\Http\Response|null
     * @throws \Cake\Http\Exception\ForbiddenException When a directory traversal attempt.
     * @throws \Cake\View\Exception\MissingTemplateException When the view file could not
     *   be found and in debug mode.
     * @throws \Cake\Http\Exception\NotFoundException When the view file could not
     *   be found and not in debug mode.
     */

    /**
     * @var \App\Model\Table\EnquiriesTable $EnquiryTable
     */

    private EnquiriesTable $EnquiryTable;

    public function initialize(): void
    {
        parent::initialize(); // TODO: Change the autogenerated stub
        $this->Authentication->allowUnauthenticated(['display','studentRegister','volunteerRegister']);
        $this->EnquiryTable= $this->fetchTable('Enquiries');
        
        
    }

    public function display(string ...$path): ?Response
    {
        $enquiry= $this->EnquiryTable->newEmptyEntity();
        if (!$path) {
            $path = ['home'];        }

        if (in_array('..', $path, true) || in_array('.', $path, true)) {
            throw new ForbiddenException();
        }

        $page = $subpage = null;

        if (!empty($path[0])) {
            $page = $path[0];
        }

        if (!empty($path[1])) {
            $subpage = $path[1];
        }

        if ($this->request->is('post')) {
            $data = $this->request->getData();
            $enquiry = $this->EnquiryTable->patchEntity($enquiry, $data);
            if ($this->EnquiryTable->save($enquiry)) {
                $mailer = new Mailer('default');
                $mailer->setTo('satyam983585@gmail.com')
                    ->setSubject('New Enquiry Received')
                    ->setEmailFormat('html')
                    ->setViewVars([
                        'name' => $enquiry->name,
                        'email' => $enquiry->email,
                        'subject' => $enquiry->subject,
                        'message' => $enquiry->message
                    ])
                    ->viewBuilder()
                    ->setTemplate('enquiry_notification');

                try {
                    if ($mailer->deliver()) {
                        $this->Flash->success(__('Your enquiry has been sent successfully.'));
                        return $this->redirect(['action' => 'display', $page]);
                    } else {
                        $this->Flash->error('Error sending password reset email. Please try again.');
                    }
                } catch (\Exception $e) {
                    $this->Flash->error('Email error: ' . $e->getMessage());
                    \Cake\Log\Log::error('Email error: ' . $e->getMessage());
                }
            } else {
                $this->Flash->error(__('Unable to submit your enquiry. Please check the form and try again.'));
            }
        }

        $page = $path[0] ?? 'home';
        $subpage = $path[1] ?? null;
        $title = ucwords(str_replace('-', ' ', $page));
    
        $programsTable = TableRegistry::getTableLocator()->get('Programs');
        $programs = $programsTable->find()
            ->contain(['ProgramStatuses', 'ProgramsImages'])
            ->all();
        $this->set(compact('programs', 'page', 'subpage', 'title'));
        $this->render(implode('/', $path));

        $this->set(compact('page', 'subpage','enquiry'));

        $faqsTable = $this->getTableLocator()->get('Faqs');
        $faqs = $faqsTable->find('all');
        $this->set(compact('faqs'));

        try {
            return $this->render(implode('/', $path));
        } catch (MissingTemplateException $exception) {
            if (Configure::read('debug')) {
                throw $exception;
            }
            throw new NotFoundException();
        }

        
    }

    public function studentRegister()
{
    // Get the Students table using TableRegistry
    $studentsTable = TableRegistry::getTableLocator()->get('Students');
    // Get the Programs table using TableRegistry
    $programsTable = TableRegistry::getTableLocator()->get('Programs');

    // Initialize an empty student entity (for single student form submission)
    $student = $studentsTable->newEmptyEntity();

    if ($this->request->is('post')) {

        // Get posted data
        $contact_name = $this->request->getData('contact_name');
        $contact_email = $this->request->getData('contact_email');
        $contact_phone = $this->request->getData('contact_phone');

        $names = $this->request->getData('name');
        $years = $this->request->getData('year');
        $schools = $this->request->getData('school');
        $programs = $this->request->getData('programsData') ?? [];

        // Decode any JSON-encoded programs if needed
        foreach ($programs as &$programsArray) {
            if (is_string($programsArray[0])) {
                $programsArray = json_decode($programsArray[0], true);
            }
        }

        // Initialize counters for success and failure
        $students = [];
        $successCount = 0;
        $failureCount = 0;

        // Loop through each student and create or update their record
        foreach ($names as $index => $name) {
            // Create a new empty student entity
            $student = $studentsTable->newEmptyEntity();

            // Patch the student entity with form data
            $student = $studentsTable->patchEntity($student, [
                'name' => $name,
                'year_level' => $years[$index],
                'school' => $schools[$index],
                'contact_name' => $contact_name,
                'contact_phone' => $contact_phone,
                'contact_email' => $contact_email,
                'registration_date' => null,
                'student_status_id' => 0
            ], ['validate' => false]);
            

            // Get the selected programs for the student (if any)
            $selectedPrograms = isset($programs[$index]) ? $programs[$index] : [];

            // If programs are selected, fetch the program entities from the Programs table
            if (!empty($selectedPrograms)) {
                // Fetch program entities based on selected program IDs
                $programEntities = $programsTable->find()
                    ->where(['id IN' => $selectedPrograms])
                    ->toArray();  // Convert the result set to an array

                // Assign the fetched programs to the student entity
                $student->programs = $programEntities;
            } else {
                // If no programs are selected, ensure the programs are empty
                $student->programs = [];
            }

            // Save the student entity to the database
            if ($studentsTable->save($student)) {
                $students[] = $student;  // Add to the list of saved students
                $successCount++;  // Increment success count
            } else {
                $failureCount++;  // Increment failure count if save fails
            }
        }

        // Flash success or failure messages
        if ($successCount > 0) {
            $this->Flash->success(
                __($successCount . ' student(s) have been registered successfully.')
            );
            return $this->redirect(['action' => 'studentRegister']);

        }

        if ($failureCount > 0) {
            $this->Flash->error(
                __('There were ' . $failureCount . ' student(s) that could not be saved. Please, try again.')
            );
        }
    }

    // Fetch the list of available programs to show in the form
    $programs = $programsTable->find('list')->limit(200)->all();
    // Pass the data to the view, including the student entity for errors
    $this->set(compact('programs', 'student'));
}


    public function volunteerRegister()
    {
        // Get the Volunteers table
        $volunteersTable = TableRegistry::getTableLocator()->get('Volunteers');

        // Create an empty volunteer entity (model)
        $volunteer = $volunteersTable->newEmptyEntity();



        // Check if the form was submitted
        if ($this->request->is('post')) {
            // Patch the incoming data into the volunteer entity
            $volunteer = $volunteersTable->patchEntity($volunteer, $this->request->getData());


            // Try saving the volunteer data
            if ($volunteersTable->save($volunteer)) {
                $this->Flash->success(__('The volunteer has been saved.'));
                return $this->redirect(['action' => 'volunteerRegister']);
            }else{
                $this->Flash->error(__('The volunteer could not be saved. Please, try again.'));
            }
        }

        // Pass the volunteer entity to the view
        $this->set(compact('volunteer'));
    }
    // src/Controller/PagesController.php

    public function home()
    {
        $this->loadModel('Programs','faqs'); 
    
        $query = $this->Programs->find()
            ->contain(['ProgramStatuses', 'ProgramsImages']); 
        $programs = $query->all(); 
    
        $faqsTable = $this->getTableLocator()->get('Faqs');
        $faqs = $faqsTable->find('all');
    
        $this->set(compact('programs', 'faqs'));
    }
    
    public function faq()
{
    $faqsTable = $this->getTableLocator()->get('Faqs');
    $faqs = $faqsTable->find('all');
    $this->set(compact('faqs'));
}

    
}

