<?php
declare(strict_types=1);

namespace App\Controller;

/**
 * ProgramsImages Controller
 *
 * @property \App\Model\Table\ProgramsImagesTable $ProgramsImages
 */
class ProgramsImagesController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function initialize(): void
    {
        parent::initialize(); // TODO: Change the autogenerated stub
        $this->viewBuilder()->setLayout('adminlayout');

    }

    public function index()
    {
        $query = $this->ProgramsImages->find()
            ->contain(['Programs']);
        $programsImages = $this->paginate($query);

        $this->set(compact('programsImages'));
    }

    /**
     * View method
     *
     * @param string|null $id Programs Image id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $programsImage = $this->ProgramsImages->get($id, contain: ['Programs']);
        $this->set(compact('programsImage'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
//    public function add()
//    {
//        $programsImage = $this->ProgramsImages->newEmptyEntity();
//        if ($this->request->is('post')) {
//            $imageFile = $this->request->getData('epk_file_path');
//
//            $programsImage = $this->ProgramsImages->patchEntity($programsImage, $this->request->getData());
//            if ($this->ProgramsImages->save($programsImage)) {
//                $this->Flash->success(__('The programs image has been saved.'));
//
//                return $this->redirect(['action' => 'index']);
//            }
//            $this->Flash->error(__('The programs image could not be saved. Please, try again.'));
//        }
//        $programs = $this->ProgramsImages->Programs->find('list', limit: 200)->all();
//        $this->set(compact('programsImage', 'programs'));
//    }

public function add()
{
    $programsImage = $this->ProgramsImages->newEmptyEntity();

    if ($this->request->is('post')) {
        $programsImage = $this->ProgramsImages->patchEntity($programsImage, $this->request->getData());
        if ($this->ProgramsImages->save($programsImage)) {
            $this->Flash->success(__('The programs image has been saved.'));

            return $this->redirect(['action' => 'index']);
        }
        $this->Flash->error(__('The programs image could not be saved. Please, try again.'));
    }

    $programs = $this->ProgramsImages->Programs->find('list', ['limit' => 200])->all(); // This line is important

    $this->set(compact('programsImage', 'programs')); // Make sure $programs is included
}


    /**
     * Edit method
     *
     * @param string|null $id Programs Image id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
//    public function edit($id = null)
//    {
//        $programsImage = $this->ProgramsImages->get($id, contain: []);
//        if ($this->request->is(['patch', 'post', 'put'])) {
//            $programsImage = $this->ProgramsImages->patchEntity($programsImage, $this->request->getData());
//            if ($this->ProgramsImages->save($programsImage)) {
//                $this->Flash->success(__('The programs image has been saved.'));
//
//                return $this->redirect(['action' => 'index']);
//            }
//            $this->Flash->error(__('The programs image could not be saved. Please, try again.'));
//        }
//        $programs = $this->ProgramsImages->Programs->find('list', limit: 200)->all();
//        $this->set(compact('programsImage', 'programs'));
//    }

    public function edit($id = null)
    {
        // Fetch the existing programs image
        $programsImage = $this->ProgramsImages->get($id, contain: []);

        if ($this->request->is(['patch', 'post', 'put'])) {
            $imageFile = $this->request->getData('image_name');

            // If a new image is uploaded
            if ($imageFile && $imageFile->getError() === UPLOAD_ERR_OK) {
                // File type validation - whitelist approach
                $allowedTypes = ['image/jpeg', 'image/png', 'image/gif'];
                $allowedExtensions = ['jpg', 'jpeg', 'png', 'gif'];

                $fileType = $imageFile->getClientMediaType();
                $extension = strtolower(pathinfo($imageFile->getClientFilename(), PATHINFO_EXTENSION));

                // Validate file type and extension
                if (!in_array($fileType, $allowedTypes) || !in_array($extension, $allowedExtensions)) {
                    $this->Flash->error(__('Invalid file type. Only JPG, PNG, or GIF files are allowed.'));
                    $this->set(compact('programsImage'));
                    return;
                }

                // Ensure the upload directory exists
                $uploadDir = WWW_ROOT . 'uploads/img/';
                if (!is_dir($uploadDir)) {
                    mkdir($uploadDir, 0777, true);
                }

                // Generate a secure filename
                $filename = time() . '_' . bin2hex(random_bytes(8)) . '.' . $extension;
                $filePath = $uploadDir . $filename;

                // Move the new file to the upload directory
                if ($imageFile->moveTo($filePath)) {
                    // Update the image path with the new file path
                    $data = $this->request->getData();
                    $data['image_name'] = 'uploads/img/' . $filename;  // Store relative file path
                }
//                else {
//                    // Handle file move failure
//                    $this->Flash->error(__('There was an error uploading the image file.'));
//                    $this->set(compact('programsImage'));
//                    return;
//                }
            } else {
                // If no new image is uploaded, keep the existing image path
                $data = $this->request->getData();
                $data['image_name'] = $programsImage->image_name;
            }

            // Patch the entity with the form data (including new image path if available)
            $programsImage = $this->ProgramsImages->patchEntity($programsImage, $data);

            // Save the entity to the database
            if ($this->ProgramsImages->save($programsImage)) {
                $this->Flash->success(__('The programs image has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The programs image could not be saved. Please, try again.'));
            }
        }

        // Fetch programs for the dropdown list
        $programs = $this->ProgramsImages->Programs->find('list', ['limit' => 200])->all();
        $this->set(compact('programsImage', 'programs'));
    }


    /**
     * Delete method
     *
     * @param string|null $id Programs Image id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $programsImage = $this->ProgramsImages->get($id);
        if ($this->ProgramsImages->delete($programsImage)) {
            $this->Flash->success(__('The programs image has been deleted.'));
        } else {
            $this->Flash->error(__('The programs image could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
