<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * ProgramsStudent Entity
 *
 * @property int $id
 * @property int|null $program_id
 * @property int|null $student_id
 * @property string|null $status
 *
 * @property \App\Model\Entity\Program $program
 * @property \App\Model\Entity\Student $student
 */
class ProgramsStudent extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'program_id' => true,
        'student_id' => true,
        'status' => true,
        'program' => true,
        'student' => true,
    ];
}
