<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Student Entity
 *
 * @property int $id
 * @property string $first_name
 * @property string $last_name
 * @property string|null $year_level
 * @property string|null $school
 * @property string|null $contact_first_name
 * @property string|null $contact_last_name
 * @property string|null $contact_phone
 *
 * @property \App\Model\Entity\Program[] $programs
 */
class Student extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'name' => true,
        'year_level' => true,
        'school' => true,
        'contact_name' => true,
        'contact_phone' => true,
        'registration_date' => true,
        'student_status_id' => true,
        'programs' => true,
        'contact_email' => true
    ];
}
