<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Volunteer Entity
 *
 * @property int $id
 * @property string $first_name
 * @property string $last_name
 * @property string $email
 * @property string|null $phone
 * @property string|null $postcode
 * @property string|null $occupation
 * @property string|null $description
 * @property int|null $volunteer_status_id
 *
 * @property \App\Model\Entity\VolunteerStatus $volunteer_status
 * @property \App\Model\Entity\Program[] $programs
 */
class Volunteer extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'first_name' => true,
        'last_name' => true,
        'email' => true,
        'phone' => true,
        'postcode' => true,
        'occupation' => true,
        'description' => true,
        'volunteer_status_id' => true,
        'volunteer_status' => true,
        'programs' => true,
    ];
}
