<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * ProgramsVolunteers Model
 *
 * @property \App\Model\Table\ProgramsTable&\Cake\ORM\Association\BelongsTo $Programs
 * @property \App\Model\Table\VolunteersTable&\Cake\ORM\Association\BelongsTo $Volunteers
 *
 * @method \App\Model\Entity\ProgramsVolunteer newEmptyEntity()
 * @method \App\Model\Entity\ProgramsVolunteer newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\ProgramsVolunteer> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\ProgramsVolunteer get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\ProgramsVolunteer findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\ProgramsVolunteer patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\ProgramsVolunteer> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\ProgramsVolunteer|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\ProgramsVolunteer saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\ProgramsVolunteer>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ProgramsVolunteer>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\ProgramsVolunteer>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ProgramsVolunteer> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\ProgramsVolunteer>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ProgramsVolunteer>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\ProgramsVolunteer>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ProgramsVolunteer> deleteManyOrFail(iterable $entities, array $options = [])
 */
class ProgramsVolunteersTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('programs_volunteers');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');

        $this->belongsTo('Programs', [
            'foreignKey' => 'program_id',
        ]);
        $this->belongsTo('Volunteers', [
            'foreignKey' => 'volunteer_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->integer('program_id')
            ->allowEmptyString('program_id');

        $validator
            ->integer('volunteer_id')
            ->allowEmptyString('volunteer_id');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->existsIn(['program_id'], 'Programs'), ['errorField' => 'program_id']);
        $rules->add($rules->existsIn(['volunteer_id'], 'Volunteers'), ['errorField' => 'volunteer_id']);

        return $rules;
    }
}
