<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Volunteers Model
 *
 * @property \App\Model\Table\VolunteerStatusesTable&\Cake\ORM\Association\BelongsTo $VolunteerStatuses
 * @property \App\Model\Table\ProgramsTable&\Cake\ORM\Association\BelongsToMany $Programs
 *
 * @method \App\Model\Entity\Volunteer newEmptyEntity()
 * @method \App\Model\Entity\Volunteer newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\Volunteer> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Volunteer get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\Volunteer findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\Volunteer patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\Volunteer> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Volunteer|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\Volunteer saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\Volunteer>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Volunteer>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Volunteer>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Volunteer> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Volunteer>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Volunteer>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Volunteer>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Volunteer> deleteManyOrFail(iterable $entities, array $options = [])
 */
class VolunteersTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('volunteers');
        $this->setDisplayField('first_name');
        $this->setPrimaryKey('id');

        $this->belongsTo('VolunteerStatuses', [
            'foreignKey' => 'volunteer_status_id',
        ]);
        $this->belongsToMany('Programs', [
            'foreignKey' => 'volunteer_id',
            'targetForeignKey' => 'program_id',
            'joinTable' => 'programs_volunteers',
        ]);
    }
    // Validation for volunteers


    public function validationDefault(Validator $validator): Validator
    {
    $validator
        ->requirePresence('first_name')
        ->notEmptyString('first_name')
        ->add('first_name', 'validChars', [
            'rule' => ['custom', '/^[a-zA-Z\s]+$/'],
            'message' => 'Only letters and spaces allowed.'
        ])
        ->requirePresence('last_name')
        ->notEmptyString('last_name')
        ->add('last_name', 'validChars', [
            'rule' => ['custom', '/^[a-zA-Z\s]+$/'],
            'message' => 'Only letters and spaces allowed.'
        ])
        ->requirePresence('email')
        ->notEmptyString('email')
        ->email('email', false, 'Please provide a valid email.')
        ->requirePresence('phone')
        ->notEmptyString('phone')
        ->add('phone', 'numeric', [
            'rule' => ['custom', '/^[0-9]+$/'],
            'message' => 'Phone must be numeric.'
        ])
        ->requirePresence('postcode')
        ->notEmptyString('postcode')
        ->add('postcode', 'numeric', [
            'rule' => ['custom', '/^[0-9]+$/'],
            'message' => 'Postcode must be numeric.'
        ])
        ->add('phone', 'length', [
            'rule' => ['custom', '/^\d{10}$/'],
            'message' => 'Phone number must be 10 digits.'
        ])

        ->requirePresence('occupation')
        ->notEmptyString('occupation')
        ->add('occupation', 'validChars', [
            'rule' => ['custom', '/^[a-zA-Z\s]+$/'],
            'message' => 'Only letters and spaces allowed.'
        ])
        ->requirePresence('description');
        

    return $validator;
}

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->isUnique(['email'], 'This email is already taken, please choose another one.'), ['errorField' => 'email']);
        $rules->add($rules->existsIn(['volunteer_status_id'], 'VolunteerStatuses'), ['errorField' => 'volunteer_status_id']);

        return $rules;
    }
}

