<?php
/**
 * @var \App\View\AppView $this
 */

$this->layout = 'login';
$this->assign('title', 'Login');
$loginPagePath= $this->Html->link(['controller' => 'Auth', 'action' => 'register']
)
?>

<div class="signup-wrapper">
    <div class="signup-container animate-container">
        <h1 class="signup-title">Login</h1>
        <p class="signup-subtitle">Sign in to your account</p>

        <?= $this->Form->create() ?>
        <?php echo $this->Flash->render(); ?>

        <div class="form-group animate-field">
            <?= $this->Form->control('email', [
                'label' => false,
                'placeholder' => 'Email',
                'type' => 'email',
                'required' => true,
                'class' => 'form-input'
            ]) ?>
        </div>

        <div class="form-group animate-field">
            <?= $this->Form->control('password', [
                'label' => false,
                'placeholder' => 'Password',
                'type' => 'password',
                'required' => true,
                'class' => 'form-input'
            ]) ?>
        </div>

        <div class="form-group animate-field">
            <div class="g-recaptcha" data-sitekey="6Lc1kgArAAAAAH90xZl8S-zQYMya4H5ypHJBOrlR"></div>
            <div class="invalid-feedback" id="recaptchaError"></div>
        </div>

        <div class="form-group">
            <?= $this->Form->button('Login', ['class' => 'submit-btn']) ?>
        </div>


        <hr class="hr-between-buttons">
<!--        <p class="signup-footer"><a href="/auth/forgetPassword">Forgot Password?</a></p>-->
        <p class="signup-footer"> <?= $this->Html->link('Forgot Password?', ['controller' => 'Auth', 'action' => 'forget_password']) ?></p>
        <p class="signup-footer"> <?= $this->Html->link('Back to Home Page', ['controller' => 'pages', 'action' => '']) ?></p>
        <?= $this->Form->end() ?>
    </div>
</div>

<style>
    /* Using the same styles as the register page */
    * {
        box-sizing: border-box;
        margin: 0;
        padding: 0;
        font-family: 'Arial', sans-serif;
    }

    .signup-wrapper {
        min-height: 100vh;
        display: flex;
        justify-content: center;
        align-items: center;
        background: linear-gradient(120deg, #f3884a, #9f3e02);
        padding: 15px;
    }

    .signup-container {
        background: #fff;
        padding: 3rem;
        border-radius: 10px;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.15);
        width: 100%;
        max-width: 480px;
        transition: all 0.3s ease;
    }

    .animate-container {
        animation: fadeIn 0.8s ease-out;
    }

    @keyframes fadeIn {
        0% { opacity: 0; transform: translateY(-20px); }
        100% { opacity: 1; transform: translateY(0); }
    }

    .signup-title {
        font-size: clamp(1.5rem, 5vw, 2rem);
        font-weight: 700;
        text-align: center;
        color: #2d3436;
        margin-bottom: 0.5rem;
    }

    .signup-subtitle {
        font-size: clamp(0.875rem, 3vw, 1rem);
        text-align: center;
        color: #636e72;
        margin-bottom: 1.5rem;
    }

    .form-group {
        width: 100%;
    }

    .form-input {
        width: 100%;
        padding: 0.75rem;
        border: 1px solid #dfe6e9;
        border-radius: 6px;
        font-size: clamp(0.875rem, 2.5vw, 1rem);
        transition: border-color 0.3s ease, box-shadow 0.3s ease;
        height: 45px;
    }

    .form-input:focus {
        outline: none;
        border-color: #e87532;
        box-shadow: 0 0 5px rgb(195, 77, 8);
    }

    .submit-btn {
        width: 100%;
        padding: 0.2rem;
        background: #e87532;
        color: #fff;
        border: none;
        border-radius: 6px;
        font-size: clamp(0.875rem, 2.5vw, 1rem);
        font-weight: bold;
        cursor: pointer;
        transition: background 0.3s ease, transform 0.2s ease;
    }

    .submit-btn:hover {
        background: #c64f08;
        transform: scale(1.05) translateY(-2px);
        box-shadow: 0 4px 10px rgba(214, 48, 49, 0.3);
    }

    .signup-footer {
        text-align: center;
        font-size: clamp(0.75rem, 2vw, 0.875rem);
        color: #636e72;
        margin-top: 1rem;
    }

    .signup-footer a {
        color: #e87532;
        text-decoration: none;
        font-weight: 500;
    }

    .signup-footer a:hover {
        text-decoration: underline;
    }

    .form-group.recaptcha-group {
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .g-recaptcha {
        display: inline-block;
    }
</style>
<script src="https://www.google.com/recaptcha/api.js" async defer></script>
