<?php
/**
 * @var \App\View\AppView $this
 * @var string $message
 * @var string $url
 */
use Cake\Core\Configure;

$this->layout = 'error';

if (Configure::read('debug')) :
    $this->layout = 'dev_error';

    $this->assign('title', $message);
    $this->assign('templateName', 'error400.php');

    $this->start('file');
    echo $this->element('auto_table_warning');
    $this->end();
endif;
?>

<div class="error-container">
    <div class="error-code">404</div>
    <h2 class="error-message"><?= h($message) ?></h2>
    <p><?= __d('cake', 'The requested address was not found on this server.') ?></p>
    <div class="original-url">
<!--        --><?php //= __d('cake', 'Attempted URL: {0}', "<strong>'{$url}'</strong>") ?>
    </div>
    <?= $this->Html->link('Return to Homepage', ['controller' => 'Pages', 'action' => 'display'], ['class' => 'homepage-btn']) ?>

</div>

<style>
    body {
        font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
        display: flex;
        justify-content: center;
        align-items: center;
        height: 100vh;
        margin: 0;
        background-color: #f4f4f4;
        text-align: center;
    }

    .error-code {
        font-size: 72px;
        color: #e74c3c;
        margin-bottom: 20px;
        font-weight: bold;
    }
    .error-message {
        color: #333;
        margin-bottom: 30px;
    }
    .homepage-btn {
        display: inline-block;
        background-color: #3498db;
        color: white;
        padding: 12px 24px;
        text-decoration: none;
        border-radius: 5px;
        transition: background-color 0.3s ease;
    }
    .homepage-btn:hover {
        background-color: #2980b9;
    }
    .original-url {
        color: #7f8c8d;
        margin-top: 20px;
        font-style: italic;
    }
</style>
