<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Faq $faq
 */
?>

<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <!-- Form Card -->
        <div class="col-12">
            <div class="card shadow p-4">
                <div class="card-header bg-primary text-white rounded mb-3 d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">Add New FAQ</h3>
                    <div>
                        <?= $this->Html->link(
                            '<i class="bx bx-arrow-back me-1"></i> Back to FAQs',
                            ['action' => 'index'],
                            ['class' => 'btn btn-secondary btn-sm', 'escape' => false]
                        ) ?>
                    </div>
                </div>

                <div class="card-body">
                    <?= $this->Flash->render() ?>

                    <?php if ($faq->getErrors()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php foreach ($faq->getErrors() as $field => $errors): ?>
                                    <?php foreach ($errors as $error): ?>
                                        <li><?= h($error) ?></li>
                                    <?php endforeach; ?>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <?= $this->Form->create($faq, ['class' => 'row g-3']) ?>

                    <div class="col-12">
                        <div class="mb-3">
                            <label class="form-label">Question <span class="text-danger">*</span></label>
                            <?= $this->Form->control('question', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter the question',
                                'required' => true,
                            ]) ?>
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="mb-3">
                            <label class="form-label">Answer <span class="text-danger">*</span></label>
                            <?= $this->Form->control('answer', [
                                'class' => 'form-control',
                                'type' => 'textarea',
                                'rows' => 5,
                                'label' => false,
                                'placeholder' => 'Enter the answer',
                                'required' => true,
                            ]) ?>
                        </div>
                    </div>

                    <div class="col-12 text-end d-flex justify-content-between">
                        <?= $this->Html->link(__('Cancel'), ['action' => 'index'], ['class' => 'btn btn-secondary']) ?>
                        <?= $this->Form->button(__('Submit'), ['class' => 'btn btn-primary']) ?>
                    </div>

                    <?= $this->Form->end() ?>
                </div>
            </div>
        </div>
    </div>
</div>
