<!-- Content -->
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <div class="col-xl">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">FAQ Management</h5>
                    <?= $this->Html->link('New FAQ', ['action' => 'add'], ['class' => 'btn btn-primary ms-3']) ?>
                </div>
                <div class="card-body">
                    <div class="table-responsive text-nowrap">
                        <table class="table table-striped">
                            <thead>
                            <tr>
                                <th><?= $this->Paginator->sort('id') ?></th>
                                <th><?= $this->Paginator->sort('question') ?></th>
                                <th><?= $this->Paginator->sort('answer') ?></th>
                                <th><?= $this->Paginator->sort('created') ?></th>
                                <th><?= $this->Paginator->sort('modified') ?></th>
                                <th class="actions"><?= __('Actions') ?></th>
                            </tr>
                            </thead>
                            <tbody class="table-border-bottom-0">
                            <?php foreach ($faqs as $faq): ?>
                                <tr>
                                    <td><?= $this->Number->format($faq->id) ?></td>
                                    <td><?= h($faq->question) ?></td>
                                    <td><?= h($faq->answer) ?></td>
                                    <td><?= $faq->created->i18nFormat('yyyy-MM-dd HH:mm') ?></td>
                                    <td><?= $faq->modified->i18nFormat('yyyy-MM-dd HH:mm') ?></td>
                                    <td class="actions">
                                        <div class="dropdown">
                                            <button type="button"
                                                    class="btn p-0 dropdown-toggle hide-arrow"
                                                    data-bs-toggle="dropdown">
                                                <i class="bx bx-dots-vertical-rounded"></i>
                                            </button>
                                            <div class="dropdown-menu">
                                                <?= $this->Html->link(
                                                    '<i class="bx bx-show-alt me-1"></i> View',
                                                    ['action' => 'view', $faq->id],
                                                    ['class' => 'dropdown-item', 'escape' => false]
                                                ) ?>
                                                <?= $this->Html->link(
                                                    '<i class="bx bx-edit-alt me-1"></i> Edit',
                                                    ['action' => 'edit', $faq->id],
                                                    ['class' => 'dropdown-item', 'escape' => false]
                                                ) ?>
                                                <?= $this->Form->postLink(
                                                    '<i class="bx bx-trash me-1"></i> Delete',
                                                    ['action' => 'delete', $faq->id],
                                                    [
                                                        'confirm' => __('Are you sure you want to delete # {0}?', $faq->id),
                                                        'class' => 'dropdown-item text-danger',
                                                        'escape' => false
                                                    ]
                                                ) ?>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        <nav aria-label="Page navigation">
                            <ul class="pagination justify-content-center">
                                <?= $this->Paginator->first('<i class="bx bx-chevrons-left"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                                <?= $this->Paginator->prev('<i class="bx bx-chevron-left"></i>', ['escape' => false, 'class' => 'page-item']) ?>

                                <?php
                                $this->Paginator->setTemplates([
                                    'number' => '<li class="page-item"><a class="page-link" href="{{url}}">{{text}}</a></li>',
                                    'current' => '<li class="page-item active"><a class="page-link" href="#">{{text}}</a></li>',
                                ]);

                                echo $this->Paginator->numbers();
                                ?>

                                <?= $this->Paginator->next('<i class="bx bx-chevron-right"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                                <?= $this->Paginator->last('<i class="bx bx-chevrons-right"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                            </ul>
                        </nav>
                        <div class="text-center text-muted mt-2">
                            <?= $this->Paginator->counter('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total') ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
