<!DOCTYPE html>
<html>
<head>
    <?= $this->Html->charset() ?>
    <?= $this->Html->meta('viewport', 'width=device-width, initial-scale=1.0') ?>
    <title>Student Registration</title>
    <!-- Include Bootstrap CSS (adjust path if needed) -->
    <?= $this->Html->css('vendor/bootstrap/css/bootstrap.min.css', ['pathPrefix' => 'assets/']) ?>
    <!-- Optionally include Bootstrap Icons -->
    <?= $this->Html->css('vendor/bootstrap-icons/bootstrap-icons.css', ['pathPrefix' => 'assets/']) ?>
    <!-- Main CSS File (EasyFolio global styles) -->
    <?= $this->Html->css('main.css', ['pathPrefix' => 'assets/css/']) ?>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <style>
        /*
          PRIMARY BRAND COLOR:
          We’re using #e87532 and a slightly darker #d7682c for gradients/hover states.
        */

        /* Card adjustments for a more polished look */
        .card {
            border: none;
            border-radius: 1rem;
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.1);
        }

        .card-header.bg-primary.text-white.rounded.mb-3 h3 {
            color: #fff !important;
        }

        /* Make the card header use a smooth gradient */
        .card-header.bg-primary.text-white.rounded.mb-3 {
            color: #fff !important;
            background: linear-gradient(45deg, #e87532, #d7682c) !important;
            border: none !important;
            border-radius: 0.8rem !important;
        }
        .card-header h3 {
            font-weight: 700;
            letter-spacing: 1px;
        }

        /* Style the primary button with a matching gradient */
        .btn-primary {
            background: linear-gradient(45deg, #e87532, #d7682c);
            border: none;
            border-radius: 0.8rem;
            font-weight: 600;
            padding: 0.6rem 1.5rem;
        }

        .btn-primary:hover,
        .btn-primary:focus {
            background: linear-gradient(45deg, #d7682c, #c65e28);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        }


        .btn-secondary {
            background: linear-gradient(45deg, #d3d3d3, #a9a9a9);
            border: none;
            border-radius: 0.8rem;
            font-weight: 600;
            padding: 0.6rem 1.5rem;
        }

        .btn-secondary:hover,
        .btn-secondary:focus {
            background: linear-gradient(45deg, #808080, #696969);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        }

        /* General label styling */
        .form-label {
            font-weight: 600;
        }

        /* Student form container with a border for clarity */
        .student-form {
            background: var(--surface-color);
            border: 1px solid #eee;
            border-radius: 0.8rem;
            box-shadow: 0 4px 6px rgba(0,0,0,0.05);
        }

        /* Form header with hover effect and refined look */
        .form-header {
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: space-between;
            font-size: 1.125rem; /* ~18px */
            font-weight: 700;
            background-color: #fafafa;
            border-bottom: 1px solid #eee;
            padding: 0.625rem 0.9375rem; /* 10px 15px */
            border-top-left-radius: 0.8rem;
            border-top-right-radius: 0.8rem;
            transition: background-color 0.3s ease;
        }
        .form-header:hover {
            background-color: #f0f0f0;
        }

        /* Icon group styling with hover transitions */
        .icon-group {
            display: flex;
            gap: 0.625rem; /* 10px */
        }
        .icon-group i {
            font-size: 1.25rem; /* 20px */
            color: #e87532;
            cursor: pointer;
            transition: color 0.3s ease, transform 0.3s ease;
        }
        .icon-group i:hover {
            color: #d7682c;
            transform: scale(1.1);
        }

        /* Arrow styling */
        .arrow {
            color: #e87532;
            font-size: 1.25rem; /* 20px */
            transition: transform 0.3s ease, color 0.3s ease;
            margin-right: 0.5rem;
        }
        .form-header:hover .arrow {
            color: #d7682c;
        }

        /* Additional spacing in the student form content */
        .form-content {
            padding-top: 0.75rem;
        }

        /* Table container */
/* Table container */
#programsTable {
    width: 100%;
    border-collapse: collapse;
    margin: 20px 0;
    font-size: 14px;
}

/* Table row and background color */
#programsTable .program-row {
    cursor: pointer;
    background-color: white; /* Default background color */
    transition: background-color 0.3s ease; /* Smooth background change */
}

/* Hover effect for unselected rows */
#programsTable .program-row:hover {
    background-color: #f1f1f1; /* Light background on hover for unselected rows */
}

/* When a row is selected */
#programsTable .program-row.selected {
    background-color: #007bff; /* Blue background for selected rows */
    color: white; /* White text color for selected rows */
}

/* Darker background when hovering over selected rows */
#programsTable .program-row.selected:hover {
    background-color: #0056b3; /* Darker blue when hovering over selected rows */
}

/* Table header styling */
#programsTable thead {
    background-color: #007bff; /* Blue header */
    color: #fff;
}

/* Table header cells */
#programsTable th {
    padding: 12px;
    text-align: left;
}

/* Table data cells */
#programsTable td {
    padding: 12px;
    text-align: left;
    border-bottom: 1px solid #ddd;
}

/* Scrollable container for the table */
#programsTable-wrapper {
    max-height: 300px;
    overflow-y: auto;
    border: 1px solid #ddd;
}

/* Optional: Add a border around the entire table */
#programsTable {
    border: 1px solid #ddd;
}

/* Optional: Add spacing between rows */
#programsTable .program-row {
    border-bottom: 1px solid #ddd;
}


</style>
</head>
<body class="index-page">

<section id="student-registration" class="py-5">
    <div class="container">
        <div class="card shadow p-4">
            <div class="card-header bg-primary text-white rounded mb-3">
                <h3 class="mb-0">Student Registration Form</h3>
            </div>

            <div class="card-body">
                <?= $this->Flash->render() ?>

                <?= $this->Form->create(null, [
                    'url' => ['controller' => 'Pages', 'action' => 'studentRegister'],
                    'id' => 'registration-form'
                ]) ?>

                <!-- Registrar Information -->
                <fieldset class="mb-4">
                    <legend>Registrar Information</legend>
                    <div class="mb-3">
                        <label class="form-label">Full Name <span class="text-danger">*</span></label>
                        <?= $this->Form->control('contact_name', [
                        'class' => 'form-control',
                        'placeholder' => 'Enter your full name',
                        'label' => false,
                        'required' => true,
                        'pattern' => '^[A-Za-z\s]+$',
                        'title' => 'Only letters and spaces are allowed',
                        'maxlength' => '100'
                    ]) ?>

                    </div>
                    <div class="mb-3">
                        <label class="form-label">Email <span class="text-danger">*</span></label>
                        <?= $this->Form->control('contact_email', [
                        'class' => 'form-control',
                        'placeholder' => 'Enter your email',
                        'label' => false,
                        'required' => true,
                        'type' => 'email',
                        'pattern' => '[^@ \t\r\n]+@[^@ \t\r\n]+\.[^@ \t\r\n]+',
                        'title' => 'Enter a valid email address',
                        'maxlength' => '80'
                    ]) ?>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Phone <span class="text-danger">*</span></label>
                        <?= $this->Form->control('contact_phone', [
                        'class' => 'form-control',
                        'placeholder' => 'Enter your phone number',
                        'label' => false,
                        'required' => true,
                        'pattern' => '^[0-9]{10}$',
                        'title' => 'Phone number must be exactly 10 digits',
                        'maxlength' => '100'

                    ]) ?>
                    </div>
                </fieldset>

                <!-- Student Details -->
                <fieldset class="mb-4">
                    <legend>Student Details</legend>
                    <div id="studentFormsContainer">
                        <!-- A student detail form is appended here by JavaScript -->
                    </div>
                </fieldset>

                <div class="text-end d-flex justify-content-between">
                <?= $this->Html->link(__('Cancel'), ['action' => 'index'], ['class' => 'btn btn-secondary']) ?>
                    <?= $this->Form->button('Submit', ['class' => 'btn btn-primary']) ?>
                </div>
                <?= $this->Form->end() ?>
            </div>
        </div>
    </div>
</section>

<!-- Hidden Student Form Template -->
<div id="studentFormTemplate" style="display: none;">
    <div class="student-form mb-3">
        <div class="form-header" onclick="toggleForm(this)">
            <div class="d-flex align-items-center">
                <strong>
                    <span class="arrow">▼</span> Student Details
                </strong>
            </div>
            <div class="icon-group">
                <!-- Plus icon adds a new student detail form -->
                <i class="bi bi-plus plus-icon" onclick="event.stopPropagation(); addStudentForm();"></i>
                <!-- Trash icon removes this student detail form -->
                <i class="bi bi-trash delete-icon" onclick="event.stopPropagation(); deleteStudentForm(this);"></i>
            </div>
        </div>
        <div class="form-content mt-3 px-3">
            <div class="mb-3">
                <label class="form-label">Full Name <span class="text-danger">*</span></label>
                <input type="text" name="name[]" class="form-control" placeholder="Enter full name"
                required pattern="^[A-Za-z\s]+$" title="Only letters and spaces are allowed"maxlength="100">
            </div>
            <div class="row mb-3">
                <div class="col-md-6">
                    <label class="form-label">Year Level <span class="text-danger">*</span></label>
                    <input type="text" name="year[]" class="form-control" placeholder="Enter year level"
                           required pattern="^[7-9]$" title="Only a single digit from 7 to 9 is allowed" maxlength="1">

                </div>
                <div class="col-md-6">
                    <label class="form-label">School <span class="text-danger">*</span></label>
                    <input type="text" name="school[]" class="form-control" placeholder="Enter School"
    required pattern="^[A-Za-z\s]+$" title="Only letters and spaces are allowed"maxlength="100">
            </div>
            <div class="mb-3">
    <label class="form-label">Programs <span class="text-danger">*</span></label>
    <table id="programsTable">
        <tbody>
            <?php foreach ($programs as $program_id => $program_name): ?>
                <tr data-program-id="<?= h($program_id) ?>" class="program-row">
                    <td>
                        <input type="checkbox" name="programs" value="<?= h($program_id) ?>" class="program-checkbox">
                        <?= h($program_name) ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <!-- Hidden input for storing selected programs will be dynamically added here -->
</div>

        </div>

    </div>
</div>

<!-- JavaScript -->
    <script>
        const container = document.getElementById('studentFormsContainer');
        const template = document.getElementById('studentFormTemplate').firstElementChild;
        const contact_name = document.querySelector('[name="contact_name"]').value;
        const contact_email = document.querySelector('[name="contact_email"]').value;
        const contact_phone = document.querySelector('[name="contact_phone"]').value;

        // Update hidden fields with registrar data
        document.querySelector('[name="contact_name"]').value = contact_name;
        document.querySelector('[name="contact_email"]').value = contact_email;
        document.querySelector('[name="contact_phone"]').value = contact_phone;

        let studentIndex = 0;

        function addStudentForm() {
            const clone = template.cloneNode(true);
            clone.style.display = 'block';

            // Hide content of all other student forms
            document.querySelectorAll('.form-content').forEach(c => c.style.display = 'none');

            // Show the new form's content
            clone.querySelector('.form-content').style.display = 'block';

            // Create a unique hidden input for each student’s selected programs
            const hiddenInput = document.createElement('input');
            hiddenInput.type = 'hidden';
            hiddenInput.name = `programsData[${studentIndex}][]`;
            hiddenInput.classList.add('programs-data');
            clone.appendChild(hiddenInput);

            container.appendChild(clone);

            studentIndex++;

            updateProgramsData(clone);
            applyRealTimeValidation(clone);
        }

        function deleteStudentForm(icon) {
            const studentForm = icon.closest('.student-form');
            const forms = document.querySelectorAll('#studentFormsContainer .student-form');
            if (forms.length === 1) {
                alert("At least one student detail must remain.");
                return;
            }
            studentForm.remove();
        }

        function toggleForm(header) {
            const content = header.nextElementSibling;
            const arrow = header.querySelector('.arrow');
            document.querySelectorAll('.form-content').forEach(c => {
                if (c !== content) c.style.display = 'none';
            });
            content.style.display = (content.style.display === 'block') ? 'none' : 'block';
            arrow.textContent = (content.style.display === 'block') ? '▲' : '▼';
        }

        window.onload = function () {
            addStudentForm();
        }

        document.querySelectorAll('.program-checkbox').forEach(checkbox => {
            checkbox.addEventListener('change', function () {
                updateProgramsData();
            });
        });

        function updateProgramsData(studentForm) {
            const checkboxes = studentForm.querySelectorAll('.program-checkbox');
            const hiddenField = studentForm.querySelector('.programs-data');

            checkboxes.forEach(checkbox => {
                checkbox.addEventListener('change', function () {
                    const selectedPrograms = [];

                    checkboxes.forEach(cbox => {
                        if (cbox.checked) {
                            selectedPrograms.push(parseInt(cbox.value, 10));
                        }
                    });

                    hiddenField.value = JSON.stringify(selectedPrograms);
                });
            });
        }

        // Real-time validation for registrar and student forms
        document.addEventListener('DOMContentLoaded', function () {
            const form = document.getElementById('registration-form');
            const fields = form.querySelectorAll('input');
            fields.forEach(field => attachValidation(field));
        });

        function attachValidation(field) {
            if (!field.nextElementSibling || !field.nextElementSibling.classList.contains('invalid-feedback')) {
                const feedback = document.createElement('div');
                feedback.className = 'invalid-feedback';
                feedback.style.display = 'none';
                field.parentNode.appendChild(feedback);
            }
            field.addEventListener('input', () => validateField(field));
        }

        function applyRealTimeValidation(container) {
            const fields = container.querySelectorAll('input');
            fields.forEach(field => attachValidation(field));
        }

        function validateField(field) {
            const pattern = field.getAttribute('pattern');
            const title = field.getAttribute('title');
            const feedback = field.parentNode.querySelector('.invalid-feedback');

            if ((field.required && field.value.trim() === '') ||
                (pattern && field.value.trim() !== '' && !(new RegExp(pattern)).test(field.value))) {
                field.classList.add('is-invalid');
                field.classList.remove('is-valid');
                if (feedback) {
                    feedback.textContent = title || 'Invalid input';
                    feedback.style.display = 'block';
                }
            } else {
                field.classList.remove('is-invalid');
                field.classList.add('is-valid');
                if (feedback) {
                    feedback.textContent = '';
                    feedback.style.display = 'none';
                }
            }
        }
    </script>


<!-- Include Bootstrap JS (adjust path if needed) -->
<?= $this->Html->script('vendor/bootstrap/js/bootstrap.bundle.min.js', ['pathPrefix' => 'assets/']) ?>
</body>



</html>




