<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Volunteer $volunteer
 */
?>
<!DOCTYPE html>
<html>
<head>
    <?= $this->Html->charset() ?>
    <?= $this->Html->meta('viewport', 'width=device-width, initial-scale=1.0') ?>
    <title>Add Volunteer</title>
    <!-- Include Bootstrap CSS -->
    <?= $this->Html->css('vendor/bootstrap/css/bootstrap.min.css', ['pathPrefix' => 'assets/']) ?>
    <!-- Include Bootstrap Icons -->
    <?= $this->Html->css('vendor/bootstrap-icons/bootstrap-icons.css', ['pathPrefix' => 'assets/']) ?>
    <!-- Main CSS File -->
    <?= $this->Html->css('main.css', ['pathPrefix' => 'assets/css/']) ?>

    <style>
        .card {
            border: none;
            border-radius: 1rem;
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.1);
        }
        .card-header {
            color: #fff !important;
            background: linear-gradient(45deg, #e87532, #d7682c) !important;
            border: none;
            border-radius: 0.8rem 0.8rem 0 0;
            padding: 1rem;
        }
        .card-header h3 {
            color: #fff !important;
        }
        .form-group {
            margin-bottom: 1rem;
        }
        .form-label {
            font-weight: 600;
            margin-bottom: 0.5rem;
        }
        .form-control {
            border-radius: 0.5rem;
            padding: 0.75rem 1rem;
            box-shadow: none;
            border: 1px solid #ccc;
        }
        .form-control:focus {
            border-color: #e87532;
            box-shadow: 0 0 0 0.2rem rgba(232, 117, 50, 0.25);
        }
        .btn-primary {
            background: linear-gradient(45deg, #e87532, #d7682c);
            border: none;
            border-radius: 0.8rem;
            padding: 0.75rem 2rem;
            font-weight: 600;
        }
        .btn-primary:hover,
        .btn-primary:focus {
            background: linear-gradient(45deg, #d7682c, #c65e28);
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }
        .is-valid {
            border-color: #198754;
        }
        .is-invalid {
            border-color: #dc3545;
        }
    </style>
</head>
<body class="index-page">

<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header bg-primary text-white rounded mb-3">
                    <h3 class="mb-0">Volunteer Registration Form</h3>
                </div>
                <div class="card-body">
                    <?= $this->Flash->render() ?>
                    <?php if ($volunteer->getErrors()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php foreach ($volunteer->getErrors() as $field => $errors): ?>
                                    <?php foreach ($errors as $error): ?>
                                        <li><?= h($error) ?></li>
                                    <?php endforeach; ?>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <?= $this->Form->create(null, [
                        'url' => ['controller' => 'Pages', 'action' => 'volunteerRegister'],
                        'id' => 'registration-form', 'class' => 'row g-3'
                    ]) ?>

                    <!-- First Name -->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label">First Name</label>
                            <?= $this->Form->control('first_name', [
                                'required' => true,
                                'class' => 'form-control',
                                'placeholder' => 'Enter your first name',
                                'label' => false,
                                'pattern' => '^[A-Za-z\s]+$',
                                'title' => 'Only letters and spaces are allowed',
                                'maxlength' => '100'
                            ]) ?>
                        </div>
                    </div>

                    <!-- Last Name -->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label">Last Name</label>
                            <?= $this->Form->control('last_name', [
                                'required' => true,
                                'class' => 'form-control',
                                'placeholder' => 'Enter your last name',
                                'label' => false,
                                'pattern' => '^[A-Za-z\s]+$',
                                'title' => 'Only letters and spaces are allowed',
                                'maxlength' => '100'
                            ]) ?>
                        </div>
                    </div>

                    <!-- Email Address -->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label">Email Address</label>
                            <?= $this->Form->control('email', [
                                'required' => true,
                                'type' => 'email',
                                'class' => 'form-control',
                                'placeholder' => 'Enter email address',
                                'label' => false,
                                'pattern' => '[^@ \t\r\n]+@[^@ \t\r\n]+\.[^@ \t\r\n]+',
                                'title' => 'Enter a valid email address',
                                'maxlength' => '50'
                            ]) ?>
                        </div>
                    </div>

                    <!-- Phone Number -->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label">Phone Number</label>
                            <?= $this->Form->control('phone', [
                                'required' => true,
                                'type' => 'text',
                                'class' => 'form-control',
                                'placeholder' => 'Enter phone number',
                                'label' => false,
                                'pattern' => '^[0-9]{10}$',
                                'title' => 'Phone number must be exactly 10 digits'
                            ]) ?>
                        </div>
                    </div>

                    <!-- Postcode -->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label">Postcode</label>
                            <?= $this->Form->control('postcode', [
                                'required' => true,
                                'type' => 'text',
                                'class' => 'form-control',
                                'placeholder' => 'Enter postcode',
                                'label' => false,
                                'pattern' => '^[0-9]+$',
                                'title' => 'Postcode must contain digits only',
                                'maxlength' => '4'
                            ]) ?>
                        </div>
                    </div>

                    <!-- Occupation -->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label">Occupation</label>
                            <?= $this->Form->control('occupation', [
                                'required' => true,
                                'type' => 'text',
                                'class' => 'form-control',
                                'placeholder' => 'Enter occupation',
                                'label' => false,
                                'pattern' => '^[A-Za-z\s]+$',
                                'title' => 'Only letters and spaces are allowed',
                                'maxlength' => '100'
                            ]) ?>
                        </div>
                    </div>

                    <!-- Hidden Description -->
                    <?= $this->Form->control('description', [
                        'class' => 'form-control',
                        'label' => false,
                        'id' => 'description',
                        'type' => 'hidden'
                    ]) ?>

                    <!-- Submit Buttons -->
                    <div class="col-12">
                        <hr class="my-4">
                        <?= $this->Form->button(__('Create Volunteer'), ['class' => 'btn btn-primary me-2']) ?>
                        <?= $this->Html->link(__('Cancel'), ['action' => 'index'], ['class' => 'btn btn-outline-secondary']) ?>
                    </div>

                    <?= $this->Form->end() ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Bootstrap JS -->
<?= $this->Html->script('vendor/bootstrap/js/bootstrap.bundle.min.js', ['pathPrefix' => 'assets/']) ?>

<!-- Real-time validation script -->
<?= $this->Html->scriptBlock("
document.addEventListener('DOMContentLoaded', function () {
    const form = document.getElementById('registration-form');
    const fields = form.querySelectorAll('input');

    fields.forEach(field => {
        // Add an invalid-feedback element if it doesn't exist
        if (!field.nextElementSibling || !field.nextElementSibling.classList.contains('invalid-feedback')) {
            const feedback = document.createElement('div');
            feedback.className = 'invalid-feedback';
            feedback.style.display = 'none';
            field.parentNode.appendChild(feedback);
        }

        field.addEventListener('input', () => validateField(field));
    });

    function validateField(field) {
        const pattern = field.getAttribute('pattern');
        const title = field.getAttribute('title');
        const feedback = field.parentNode.querySelector('.invalid-feedback');

        if (pattern && field.value !== '') {
            const regex = new RegExp(pattern);
            if (!regex.test(field.value)) {
                field.setCustomValidity(title);
                field.classList.add('is-invalid');
                field.classList.remove('is-valid');
                if (feedback) {
                    feedback.textContent = title;
                    feedback.style.display = 'block';
                }
            } else {
                field.setCustomValidity('');
                field.classList.remove('is-invalid');
                field.classList.add('is-valid');
                if (feedback) {
                    feedback.textContent = '';
                    feedback.style.display = 'none';
                }
            }
        } else {
            field.setCustomValidity('');
            field.classList.remove('is-invalid');
            field.classList.remove('is-valid');
            if (feedback) {
                feedback.textContent = '';
                feedback.style.display = 'none';
            }
        }
    }
});
") ?>
</body>
</html>
