<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Program $program
 * @var \Cake\Collection\CollectionInterface|string[] $programStatuses
 * @var \Cake\Collection\CollectionInterface|string[] $students
 * @var \Cake\Collection\CollectionInterface|string[] $volunteers
 */
?>
<div class="content-wrapper">
    <div class="container-xxl flex-grow-1 container-p-y">

        <div class="row">
            <!-- Form Card -->
            <div class="col-12">
                <div class="card mb-4">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Add Program</h5>
                        <?= $this->Html->link(
                            '<i class="bx bx-arrow-back me-1"></i> Back to Programs',
                            ['action' => 'index'],
                            ['class' => 'btn btn-secondary btn-sm', 'escape' => false]
                        ) ?>
                    </div>
                    <div class="card-body">
                        <?= $this->Form->create($program, ['class' => 'row g-3', 'type' => 'post', 'enctype' => 'multipart/form-data']) ?>


                        <!-- Program Name -->
                        <div class="col-md-12">
                            <div class="form-group mb-3">
                                <label class="form-label" for="name">Program Name</label>
                                <?= $this->Form->control('name', [
                                    'class' => 'form-control',
                                    'label' => false,
                                    'placeholder' => 'Enter program name',
                                    'id' => 'name'
                                ]) ?>
                            </div>
                        </div>


                        <!-- Program Date -->
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="form-label" for="date">Date</label>
                                <?= $this->Form->control('date', [
                                    'class' => 'form-control',
                                    'label' => false,
                                    'type' => 'date',
                                    'id' => 'date'
                                ]) ?>
                            </div>
                        </div>

                        <!-- Program Time -->
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="form-label" for="time">Time</label>
                                <?= $this->Form->control('time', [
                                    'class' => 'form-control',
                                    'label' => false,
                                    'type' => 'time',
                                    'id' => 'time',
                                    'step' => '60' // This ensures only hours and minutes are allowed, no seconds.
                                ]) ?>
                            </div>
                        </div>

                        <!-- Program Status -->
                        <div class="col-md-12">
                            <div class="form-group mb-3">
                                <label class="form-label" for="program-status-id">Program Status</label>
                                <?= $this->Form->control('program_status_id', [
                                    'options' => $programStatuses,
                                    'empty' => true,
                                    'empty' => 'Select Program Status',
                                    'class' => 'form-control',
                                    'label' => false,
                                    'id' => 'program-status-id'
                                ]) ?>
                            </div>
                        </div>

                        <!-- Replace the existing Students Section with this improved version -->
                        <div class="col-md-12">
                            <div class="form-group mb-3">
                                <label class="form-label">Students</label>
                                <div id="students-container">
                                    <div class="student-entry d-flex align-items-center">
                                        </div>
                                </div>
                                <button type="button" id="add-student" class="btn mt-2" style="background-color: #e87532; color: white;">+ Add Student</button>
                            </div>
                        </div>

                        <!-- Replace the existing Volunteers Section with this improved version -->
                        <div class="col-md-12">
                            <div class="form-group mb-3">
                                <label class="form-label">Volunteers</label>
                                <div id="volunteers-container">
                                    <div class="volunteer-entry d-flex align-items-center">
                                        </div>
                                </div>
                                <button type="button" id="add-volunteer" class="btn mt-2" style="background-color: #e87532; color: white;">+ Add Volunteer</button>
                            </div>
                        </div>

                    

                        <div class="col-md-12">
    <div class="form-group mb-3">
        <label class="form-label" for="image-files">Program Images</label>

        <div class="custom-file-upload">
            <?php
            echo $this->Form->control('image_files[]', [
                'type' => 'file',
                'label' => false,
                'id' => 'image-files',
                'class' => 'form-control custom-file-input',
                'accept' => 'image/jpeg, image/png',  // Restrict file types to .jpg and .png
                'multiple' => true,  // Allow multiple file uploads
                'data-preview-container' => '#images-container',
                'hidden' => true,
            ]);
            ?>
        </div>

        <div id="images-container" class="mt-3">
            <!-- Dynamically added image previews will appear here -->
        </div>

        <div id="error-message-container" style="color: red; display: none;"></div>

        <button type="button" id="add-image" class="btn mt-2" style="background-color: #e87532; color: white;">+ Add Image</button>
        <br>
        <small>Supported formats: JPG, PNG (Max 5MB per file)</small>
    </div>
</div>


                        <!-- Submit Buttons -->
                        <div class="col-12">
                            <hr class="my-4">
                            <?= $this->Form->button(__('Create Program'), [
                                'class' => 'btn btn-primary me-2'
                            ]) ?>

                            <?= $this->Html->link(
                                __('Cancel'),
                                ['action' => 'index'],
                                ['class' => 'btn btn-outline-secondary']
                            ) ?>
                        </div>
                        <?= $this->Form->end() ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add this script tag at the end of your file, just before the closing </div> tags -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
    // Get references to the containers and buttons for students and volunteers
    const studentsContainer = document.getElementById('students-container');
    const addStudentBtn = document.getElementById('add-student');
    const volunteersContainer = document.getElementById('volunteers-container');
    const addVolunteerBtn = document.getElementById('add-volunteer');

    // Counter for tracking the number of students and volunteers
    let studentCounter = 0; // Start at 0 since no students are shown initially
    let volunteerCounter = 0; // Start at 0 since no volunteers are shown initially

    // Function to update remove buttons visibility
    function updateRemoveButtons(container, type) {
        const entries = container.querySelectorAll(`.${type}-entry`);
        const removeButtons = container.querySelectorAll(`.remove-${type}`);
        removeButtons.forEach(btn => btn.style.display = entries.length > 1 ? 'inline-block' : 'none');
    }

    // Function to add a new student entry
    function addStudentEntry() {
        studentCounter++;

        // Create a new student entry
        const newEntry = document.createElement('div');
        newEntry.className = 'student-entry d-flex align-items-center mt-2';

        // Create the select element for students
        const selectWrapper = document.createElement('div');
        selectWrapper.className = 'input select';
        selectWrapper.style.flex = '1';

        const newSelect = document.createElement('select');
        newSelect.name = `students[_ids][${studentCounter}]`;
        newSelect.className = 'form-control student-select';

        const studentOptions = <?= json_encode($students) ?>;

        let emptyOption = document.createElement('option');
        emptyOption.value = '';
        emptyOption.text = '';
        newSelect.appendChild(emptyOption);

        for (let id in studentOptions) {
            let option = document.createElement('option');
            option.value = id;
            option.text = studentOptions[id];
            newSelect.appendChild(option);
        }

        selectWrapper.appendChild(newSelect);

        // Create remove button
        const removeBtn = document.createElement('button');
        removeBtn.type = 'button';
        removeBtn.className = 'btn btn-danger remove-student ms-2';
        removeBtn.textContent = 'Remove';
        removeBtn.addEventListener('click', function() {
            newEntry.remove();
            updateRemoveButtons(studentsContainer, 'student');
        });

        newEntry.appendChild(selectWrapper);
        newEntry.appendChild(removeBtn);

        studentsContainer.appendChild(newEntry);

        updateRemoveButtons(studentsContainer, 'student');
    }

    // Function to add a new volunteer entry
    function addVolunteerEntry() {
        volunteerCounter++;

        const newEntry = document.createElement('div');
        newEntry.className = 'volunteer-entry d-flex align-items-center mt-2';

        const selectWrapper = document.createElement('div');
        selectWrapper.className = 'input select';
        selectWrapper.style.flex = '1';

        const newSelect = document.createElement('select');
        newSelect.name = `volunteers[_ids][${volunteerCounter}]`;
        newSelect.className = 'form-control volunteer-select';

        const volunteerOptions = <?= json_encode($volunteers) ?>;

        let emptyOption = document.createElement('option');
        emptyOption.value = '';
        emptyOption.text = '';
        newSelect.appendChild(emptyOption);

        for (let id in volunteerOptions) {
            let option = document.createElement('option');
            option.value = id;
            option.text = volunteerOptions[id];
            newSelect.appendChild(option);
        }

        selectWrapper.appendChild(newSelect);

        const removeBtn = document.createElement('button');
        removeBtn.type = 'button';
        removeBtn.className = 'btn btn-danger remove-volunteer ms-2';
        removeBtn.textContent = 'Remove';
        removeBtn.addEventListener('click', function() {
            newEntry.remove();
            updateRemoveButtons(volunteersContainer, 'volunteer');
        });

        newEntry.appendChild(selectWrapper);
        newEntry.appendChild(removeBtn);

        volunteersContainer.appendChild(newEntry);

        updateRemoveButtons(volunteersContainer, 'volunteer');
    }

    // Event listeners for adding students and volunteers
    addStudentBtn.addEventListener('click', addStudentEntry);
    addVolunteerBtn.addEventListener('click', addVolunteerEntry);
});

document.addEventListener('DOMContentLoaded', function() {
    const addImageButton = document.getElementById('add-image');
    const fileInput = document.getElementById('image-files');
    const imagesContainer = document.getElementById('images-container');
    const errorMessageContainer = document.getElementById('error-message-container');
    const maxFileSize = 5 * 1024 * 1024; // 5MB limit
    let files = []; // Array to keep track of selected files

    // Add click event listener to the add image button
    addImageButton.addEventListener('click', () => {
        fileInput.click(); // Trigger file input
    });

    // Handle file selection
    fileInput.addEventListener('change', function(event) {
        // If no files are selected (i.e., user presses cancel), clear previews and reset files array
        if (event.target.files.length === 0) {
            imagesContainer.innerHTML = ''; // Remove all previews
            files = []; // Clear the files array
            return;
        }

        const selectedFiles = Array.from(event.target.files);
        errorMessageContainer.style.display = 'none'; // Hide any previous error messages

        // Create a new array to store valid files
        const validFiles = [];

        selectedFiles.forEach(file => {
            if (file.size > maxFileSize) {
                // Display an error message if file is too large
                errorMessageContainer.textContent = `File ${file.name} is too large. Max size is 5MB.`;
                errorMessageContainer.style.display = 'block';
                return; // Skip adding this file
            } else if (!['image/jpeg', 'image/png'].includes(file.type)) {
                // Display an error message if file type is not jpg or png
                errorMessageContainer.textContent = `File ${file.name} is not a valid format. Only JPG and PNG are allowed.`;
                errorMessageContainer.style.display = 'block';
                return; // Skip adding this file
            } else {
                // Add valid files to the validFiles array
                validFiles.push(file);
            }
        });

        // If there are valid files, update the file input and preview
        if (validFiles.length > 0) {
            // Add the valid files to the files array
            files = files.concat(validFiles);

            // Add previews for the valid files
            validFiles.forEach(file => {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const previewContainer = document.createElement('div');
                    previewContainer.classList.add('preview-container');
                    
                    const imagePreview = document.createElement('img');
                    imagePreview.src = e.target.result;
                    imagePreview.classList.add('img-thumbnail');
                    imagePreview.style.maxWidth = '100px'; // Limit preview image size (adjust as needed)
                    previewContainer.appendChild(imagePreview);

                    // Create remove button
                    const removeButton = document.createElement('button');
                    removeButton.textContent = 'Remove';
                    removeButton.classList.add('btn', 'btn-danger', 'mt-2');
                    previewContainer.appendChild(removeButton);

                    // Add the preview container to the preview list
                    imagesContainer.appendChild(previewContainer);

                    // When remove button is clicked, remove the preview and update the file input
                    removeButton.addEventListener('click', function() {
                        previewContainer.remove(); // Remove the preview container
                        files.splice(files.indexOf(file), 1); // Remove the file from the files array
                        updateFileInput(); // Update the file input after removal
                    });
                };
                reader.readAsDataURL(file);
            });

            // Update the file input with the new valid files
            updateFileInput();
        } else {
            // If no valid files, clear the file input's value to reset
            fileInput.value = '';
        }
    });

    // Update the file input to match the images in the preview container
    function updateFileInput() {
        const dataTransfer = new DataTransfer(); // Use DataTransfer to simulate file input

        // Add each file in the files array to the DataTransfer object
        files.forEach(file => {
            dataTransfer.items.add(file); // Add each file object, keeping its original name
        });

        fileInput.files = dataTransfer.files; // Update the file input's files
    }
});






</script>

