<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Program $program
 * @var string[]|\Cake\Collection\CollectionInterface $programStatuses
 * @var string[]|\Cake\Collection\CollectionInterface $students
 * @var string[]|\Cake\Collection\CollectionInterface $volunteers
 */
?>
<div class="content-wrapper">
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="row">
            <!-- Form Card -->
            <div class="col-12">
                <div class="card mb-4">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Edit Program</h5>
                        <div>
                            <?= $this->Html->link(
                                '<i class="bx bx-arrow-back me-1"></i> Back to Programs',
                                ['action' => 'index'],
                                ['class' => 'btn btn-secondary btn-sm', 'escape' => false]
                            ) ?>
                            <?= $this->Form->postLink(
                                '<i class="bx bx-trash me-1"></i> Delete Program',
                                ['action' => 'delete', $program->id],
                                [
                                    'confirm' => __('Are you sure you want to delete # {0}?', $program->id),
                                    'class' => 'btn btn-danger btn-sm ms-2',
                                    'escape' => false
                                ]
                            ) ?>
                        </div>
                    </div>
                    <div class="card-body">
                    <?= $this->Form->create($program, ['class' => 'row g-3', 'enctype' => 'multipart/form-data']) ?>

                        <!-- Program Name -->
                        <div class="col-md-12">
                            <div class="form-group mb-3">
                                <label class="form-label" for="name">Program Name</label>
                                <?= $this->Form->control('name', [
                                    'class' => 'form-control',
                                    'label' => false,
                                    'placeholder' => 'Enter program name',
                                    'id' => 'name'
                                ]) ?>
                            </div>
                        </div>

                        <!-- Program Date -->
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="form-label" for="date">Date</label>
                                <?= $this->Form->control('date', [
                                    'class' => 'form-control',
                                    'label' => false,
                                    'type' => 'date',
                                    'id' => 'date'
                                ]) ?>
                            </div>
                        </div>

                        <!-- Program Time -->
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="form-label" for="time">Time</label>
                                <?= $this->Form->control('time', [
                                    'class' => 'form-control',
                                    'label' => false,
                                    'type' => 'time',
                                    'id' => 'time',
                                    'step' => '60' // This ensures only hours and minutes are allowed, no seconds.
                                ]) ?>
                            </div>
                        </div>

                        <!-- Program Status -->
                        <div class="col-md-12">
                            <div class="form-group mb-3">
                                <label class="form-label" for="program-status-id">Program Status</label>
                                <?= $this->Form->control('program_status_id', [
                                    'options' => $programStatuses,
                                    'empty' => true,
                                    'class' => 'form-control',
                                    'label' => false,
                                    'id' => 'program-status-id'
                                ]) ?>
                            </div>
                        </div>

                        <!-- Students Section -->
                        <div class="col-md-12">
                            <div class="form-group mb-3">
                                <label class="form-label">Students</label>
                                <div id="students-container">
                                    <?php
                                    // Preload existing students
                                    $studentIds = $program->students ? array_column($program->students, 'id') : [];
                                        foreach ($studentIds as $index => $studentId): ?>
                                            <div class="student-entry d-flex align-items-center">
                                                <?= $this->Form->control("students._ids.{$index}", [
                                                    'options' => $students,
                                                    'class' => 'form-control student-select',
                                                    'label' => false,
                                                    'value' => $studentId
                                                ]) ?>
                                                <button type="button" class="btn btn-danger remove-student ms-2" style="display:none;">Remove</button>
                                            </div>
                                        <?php endforeach; 
                                    ?>
                                        
                                </div>
                                <button type="button" id="add-student" class="btn mt-2" style="background-color: #e87532; color: white;">+ Add Student</button>
                            </div>
                        </div>

                        <!-- Volunteers Section -->
                        <div class="col-md-12">
                            <div class="form-group mb-3">
                                <label class="form-label">Volunteers</label>
                                <div id="volunteers-container">
                                    <?php
                                    // Preload existing volunteers
                                    $volunteerIds = $program->volunteers ? array_column($program->volunteers, 'id') : [];
                                    foreach ($volunteerIds as $index => $volunteerId): ?>
                                        <div class="volunteer-entry d-flex align-items-center">
                                            <?= $this->Form->control("volunteers._ids.{$index}", [
                                                'options' => $volunteers,
                                                'class' => 'form-control volunteer-select',
                                                'label' => false,
                                                'value' => $volunteerId
                                            ]) ?>
                                            <button type="button" class="btn btn-danger remove-volunteer ms-2" style="display:none;">Remove</button>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                                <button type="button" id="add-volunteer" class="btn mt-2" style="background-color: #e87532; color: white;">+ Add Volunteer</button>
                            </div>
                        </div>

<!-- Related Images Section -->
<div class="col-md-12">
    <div class="form-group mb-3">
        <label class="form-label" for="image-files">Program Images</label>

        <!-- Existing Images (Separate List) -->
        <div id="existing-images-container" class="mt-3">
        <h5>Existing Images</h5>
<?php if (!empty($program->programs_images)): ?>
    <?php foreach ($program->programs_images as $image): ?>
        <div class="preview-container" id="image-<?= $image->id ?>" style="margin-bottom: 10px;">
            <!-- Flexbox container for image and remove button -->
            <div style="display: flex; align-items: center;">
                <img src="<?= $this->Url->build('/' . $image->image_name, ['fullBase' => true]) ?>" class="img-thumbnail" style="max-width: 100px;">
                <button type="button" class="btn btn-danger remove-image mt-2" data-image-id="<?= $image->id ?>" style="margin-left: 10px;">Remove</button>
            </div>
        </div>
    <?php endforeach; ?>
<?php else: ?>
    <p>No existing images.</p>
<?php endif; ?>
        <!-- Hidden container to store the image IDs to be removed -->
        <div id="remove-images-inputs" style="display: none;"></div> <!-- Hidden section for removed images -->

        </div>

        <!-- File Upload Section for New Images -->
        <div class="file-upload-placeholder"></div>
        <div class="custom-file-upload">
            <br>
        <h5>New Images</h5>
            <?= $this->Form->control('image_files[]', [
                'type' => 'file',
                'label' => false,
                'id' => 'image-files',
                'class' => 'form-control custom-file-input',
                'accept' => 'image/jpeg, image/png',
                'multiple' => true,
                'data-preview-container' => '#images-container',
                'hidden' => true,
            ]) ?>
        </div>

        <!-- Preview Container for New Images -->
        <div id="images-container" class="mt-3">
            <!-- Dynamically added image previews will appear here -->
        </div>

        <div id="error-message-container" style="color: red; display: none;"></div>

        <button type="button" id="add-image" class="btn mt-2" style="background-color: #e87532; color: white;">+ Add Image</button>
        <br>
        <small>Supported formats: JPG, PNG (Max 5MB per file)</small>
    </div>



                    

                        <!-- Submit Buttons -->
                        <div class="col-12">
                            <hr class="my-4">
                            <?= $this->Form->button(__('Save Changes'), [
                                'class' => 'btn btn-primary me-2'
                            ]) ?>

                            <?= $this->Html->link(
                                __('Cancel'),
                                ['action' => 'index'],
                                ['class' => 'btn btn-outline-secondary']
                            ) ?>
                        </div>
                        <?= $this->Form->end() ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- JavaScript for Dynamic Entries (same as in add view) -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Get references to the containers and buttons
        const studentsContainer = document.getElementById('students-container');
        const addStudentBtn = document.getElementById('add-student');
        const volunteersContainer = document.getElementById('volunteers-container');
        const addVolunteerBtn = document.getElementById('add-volunteer');

        // Counter for tracking the number of students and volunteers
        let studentCounter = studentsContainer.querySelectorAll('.student-entry').length;
        let volunteerCounter = volunteersContainer.querySelectorAll('.volunteer-entry').length;

        // Function to update remove buttons visibility
        function updateRemoveButtons(container, type) {
            const entries = container.querySelectorAll(`.${type}-entry`);
            const removeButtons = container.querySelectorAll(`.remove-${type}`);

            removeButtons.forEach(btn => btn.style.display = 'inline-block');
    
        }

        // Function to add a new student entry
        function addStudentEntry() {
            studentCounter++;

            // Create a new student entry
            const newEntry = document.createElement('div');
            newEntry.className = 'student-entry d-flex align-items-center mt-2';

            // Create the select element for students
            const selectWrapper = document.createElement('div');
            selectWrapper.className = 'input select';
            selectWrapper.style.flex = '1';

            const newSelect = document.createElement('select');
            newSelect.name = `students[_ids][${studentCounter}]`;
            newSelect.className = 'form-control student-select';

            // If there's an existing student entry, clone its options
            const existingSelect = studentsContainer.querySelector('.student-select');
            if (existingSelect) {
                newSelect.innerHTML = existingSelect.innerHTML;
            } else {
                // If no existing student entry, we need to populate from the server data
                // This assumes that the $students variable is available globally
                // You might need to adjust this part based on your actual implementation
                const studentOptions = <?= json_encode($students) ?>;

                // Add an empty option
                let emptyOption = document.createElement('option');
                emptyOption.value = '';
                emptyOption.text = '';
                newSelect.appendChild(emptyOption);

                // Add all student options
                for (let id in studentOptions) {
                    let option = document.createElement('option');
                    option.value = id;
                    option.text = studentOptions[id];
                    newSelect.appendChild(option);
                }
            }

            selectWrapper.appendChild(newSelect);

            // Create remove button
            const removeBtn = document.createElement('button');
            removeBtn.type = 'button';
            removeBtn.className = 'btn btn-danger remove-student ms-2';
            removeBtn.textContent = 'Remove';
            removeBtn.addEventListener('click', function() {
                newEntry.remove();
                updateRemoveButtons(studentsContainer, 'student');
            });

            // Add elements to the entry
            newEntry.appendChild(selectWrapper);
            newEntry.appendChild(removeBtn);

            // Add new entry to the container
            studentsContainer.appendChild(newEntry);

            // Update the remove buttons visibility
            updateRemoveButtons(studentsContainer, 'student');
        }

        // Function to add a new volunteer entry
        function addVolunteerEntry() {
            volunteerCounter++;

            // Create a new volunteer entry
            const newEntry = document.createElement('div');
            newEntry.className = 'volunteer-entry d-flex align-items-center mt-2';

            // Create the select element for volunteers
            const selectWrapper = document.createElement('div');
            selectWrapper.className = 'input select';
            selectWrapper.style.flex = '1';

            const newSelect = document.createElement('select');
            newSelect.name = `volunteers[_ids][${volunteerCounter}]`;
            newSelect.className = 'form-control volunteer-select';

            // If there's an existing volunteer entry, clone its options
            const existingSelect = volunteersContainer.querySelector('.volunteer-select');
            if (existingSelect) {
                newSelect.innerHTML = existingSelect.innerHTML;
            } else {
                // If no existing volunteer entry, we need to populate from the server data
                // This assumes that the $volunteers variable is available globally
                // You might need to adjust this part based on your actual implementation
                const volunteerOptions = <?= json_encode($volunteers) ?>;

                // Add an empty option
                let emptyOption = document.createElement('option');
                emptyOption.value = '';
                emptyOption.text = '';
                newSelect.appendChild(emptyOption);

                // Add all volunteer options
                for (let id in volunteerOptions) {
                    let option = document.createElement('option');
                    option.value = id;
                    option.text = volunteerOptions[id];
                    newSelect.appendChild(option);
                }
            }

            selectWrapper.appendChild(newSelect);

            // Create remove button
            const removeBtn = document.createElement('button');
            removeBtn.type = 'button';
            removeBtn.className = 'btn btn-danger remove-volunteer ms-2';
            removeBtn.textContent = 'Remove';
            removeBtn.addEventListener('click', function() {
                newEntry.remove();
                updateRemoveButtons(volunteersContainer, 'volunteer');
            });

            // Add elements to the entry
            newEntry.appendChild(selectWrapper);
            newEntry.appendChild(removeBtn);

            // Add new entry to the container
            volunteersContainer.appendChild(newEntry);

            // Update the remove buttons visibility
            updateRemoveButtons(volunteersContainer, 'volunteer');
        }

        // If there are existing entries, make them display as flex with aligned items
        const existingStudentEntries = studentsContainer.querySelectorAll('.student-entry');
        existingStudentEntries.forEach(entry => {
            entry.classList.add('d-flex', 'align-items-center');
            const selectContainer = entry.querySelector('.student-select').parentNode;
            selectContainer.style.flex = '1';
        });

        const existingVolunteerEntries = volunteersContainer.querySelectorAll('.volunteer-entry');
        existingVolunteerEntries.forEach(entry => {
            entry.classList.add('d-flex', 'align-items-center');
            const selectContainer = entry.querySelector('.volunteer-select').parentNode;
            selectContainer.style.flex = '1';
        });

        // Attach event listeners to the add buttons
        addStudentBtn.addEventListener('click', addStudentEntry);
        addVolunteerBtn.addEventListener('click', addVolunteerEntry);

        // Set up remove buttons for initial entries
        const initialStudentRemoveBtns = studentsContainer.querySelectorAll('.remove-student');
        initialStudentRemoveBtns.forEach(btn => {
            btn.addEventListener('click', function() {
                btn.closest('.student-entry').remove();
                updateRemoveButtons(studentsContainer, 'student');
            });
        });

        const initialVolunteerRemoveBtns = volunteersContainer.querySelectorAll('.remove-volunteer');
        initialVolunteerRemoveBtns.forEach(btn => {
            btn.addEventListener('click', function() {
                btn.closest('.volunteer-entry').remove();
                updateRemoveButtons(volunteersContainer, 'volunteer');
            });
        });

        // Initialize the UI state
        updateRemoveButtons(studentsContainer, 'student');
        updateRemoveButtons(volunteersContainer, 'volunteer');

        // If there are no initial entries, add a first entry for each when needed
        if (studentCounter === 0) {
            addStudentEntry();
        }

        if (volunteerCounter === 0) {
            addVolunteerEntry();
        }
    });


    document.addEventListener('DOMContentLoaded', function() {
        const addImageButton = document.getElementById('add-image');
        const fileInput = document.getElementById('image-files');
        const imagesContainer = document.getElementById('images-container');
        const existingImagesContainer = document.getElementById('existing-images-container');
        const errorMessageContainer = document.getElementById('error-message-container');
        const maxFileSize = 5 * 1024 * 1024; // 5MB limit
        let files = []; // Array to keep track of selected files

        // Add click event listener to the add image button
        addImageButton.addEventListener('click', () => {
            fileInput.click(); // Trigger file input
        });

        // Handle file selection for new images
        fileInput.addEventListener('change', function(event) {
            // If no files are selected (i.e., user presses cancel), clear previews and reset files array
            if (event.target.files.length === 0) {
                imagesContainer.innerHTML = ''; // Remove all previews
                files = []; // Clear the files array
                return;
            }

            const selectedFiles = Array.from(event.target.files);
            errorMessageContainer.style.display = 'none'; // Hide any previous error messages

            // Create a new array to store valid files
            const validFiles = [];

            selectedFiles.forEach(file => {
                if (file.size > maxFileSize) {
                    // Display an error message if file is too large
                    errorMessageContainer.textContent = `File ${file.name} is too large. Max size is 5MB.`;
                    errorMessageContainer.style.display = 'block';
                    return; // Skip adding this file
                } else if (!['image/jpeg', 'image/png'].includes(file.type)) {
                    // Display an error message if file type is not jpg or png
                    errorMessageContainer.textContent = `File ${file.name} is not a valid format. Only JPG and PNG are allowed.`;
                    errorMessageContainer.style.display = 'block';
                    return; // Skip adding this file
                } else {
                    // Add valid files to the validFiles array
                    validFiles.push(file);
                }
            });

            // If there are valid files, update the file input and preview
            if (validFiles.length > 0) {
                // Add the valid files to the files array
                files = files.concat(validFiles);

                // Add previews for the valid files
                validFiles.forEach(file => {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        const previewContainer = document.createElement('div');
                        previewContainer.classList.add('preview-container');
                        previewContainer.style.marginBottom = '10px'; // Space between image previews

                        const imagePreview = document.createElement('img');
                        imagePreview.src = e.target.result;
                        imagePreview.classList.add('img-thumbnail');
                        imagePreview.style.maxWidth = '100px'; // Limit preview image size
                        imagePreview.style.display = 'inline-block'; // Make image inline
                        previewContainer.appendChild(imagePreview);

                        // Create remove button
                        const removeButton = document.createElement('button');
                        removeButton.textContent = 'Remove';
                        removeButton.classList.add('btn', 'btn-danger', 'mt-2');
                        removeButton.style.display = 'inline-block'; // Align the button next to the image
                        removeButton.style.marginLeft = '10px'; // Space between the image and the remove button
                        previewContainer.appendChild(removeButton);

                        // Add the preview container to the preview list
                        imagesContainer.appendChild(previewContainer);

                        // When remove button is clicked, remove the preview and update the file input
                        removeButton.addEventListener('click', function() {
                            previewContainer.remove(); // Remove the preview container
                            files.splice(files.indexOf(file), 1); // Remove the file from the files array
                            updateFileInput(); // Update the file input after removal
                        });
                    };
                    reader.readAsDataURL(file);
                });

                // Update the file input with the new valid files
                updateFileInput();
            } else {
                // If no valid files, clear the file input's value to reset
                fileInput.value = '';
            }
        });

        // Update the file input to match the images in the preview container
        function updateFileInput() {
            const dataTransfer = new DataTransfer(); // Use DataTransfer to simulate file input

            // Add each file in the files array to the DataTransfer object
            files.forEach(file => {
                dataTransfer.items.add(file); // Add each file object, keeping its original name
            });

            fileInput.files = dataTransfer.files; // Update the file input's files
        }

        // Handle removing existing images (from the backend)
        const removeButtons = document.querySelectorAll('.remove-image');
        removeButtons.forEach(button => {
            button.addEventListener('click', function() {
                const imageId = button.getAttribute('data-image-id');
                // You can handle the image removal via AJAX or mark the image for deletion
                button.closest('.preview-container').remove();
                // Optionally, make an AJAX request here to notify the backend to remove the image.
            });
        });
    });


    document.addEventListener('DOMContentLoaded', function() {
    // Select all remove buttons
    const removeButtons = document.querySelectorAll('.remove-image');
    
    removeButtons.forEach(button => {
        button.addEventListener('click', function() {

            // Get the image ID from the button's data attribute
            const imageId = button.getAttribute('data-image-id');

            if (!imageId) {
                return;
            }

            // Append the image ID to the hidden input container
            const removeImagesContainer = document.getElementById('remove-images-inputs');
            
            
                const hiddenInput = document.createElement('input');
                hiddenInput.type = 'hidden';
                hiddenInput.name = 'remove_images[]'; // The name should be an array to handle multiple IDs
                hiddenInput.value = imageId; // Set the value to the image ID
                
                removeImagesContainer.appendChild(hiddenInput);
            

            // Optionally, you can remove the image preview from the DOM
            const previewContainer = button.closest('.preview-container');
            
                previewContainer.remove(); // Remove the image preview from the UI
            
        });
    });
});


document.querySelector('form').addEventListener('submit', function(event) {
    // Log the form data just before submission
    const form = event.target; // Get the form being submitted
    console.log('Form data before submission:', new FormData(form));

    // Proceed with form submission
});






</script>
