<!-- Content -->
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <div class="col-xl">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">

                    <div></div>

                    <?= $this->Html->link(('New Program'), ['action' => 'add'], ['class' => 'btn btn-primary ms-3']) ?>
                </div>
                <div class="card-body">
                    <div class="table-responsive text-nowrap">
                        <table class="table table-striped">
                            <thead>
                            <tr>
<!--                                <th>--><?php //= $this->Paginator->sort('id') ?><!--</th>-->
                                <th><?= $this->Paginator->sort('name') ?></th>
                                <th><?= $this->Paginator->sort('date') ?></th>
                                <th><?= $this->Paginator->sort('time') ?></th>
                                <th><?= $this->Paginator->sort('program_status_id') ?></th>
                            </tr>
                            </thead>
                            <tbody class="table-border-bottom-0">
                            <?php foreach ($programs as $program): ?>
                                <tr data-edit-url="<?= $this->Url->build(['controller' => 'Programs', 'action' => 'edit', $program->id]) ?>" class="clickable-row">
                                <!--     
<!--                                    <td>--><?php //= $this->Number->format($program->id) ?><!--</td>-->
                                    <td>
                                       <?= h($program->name) ?>
                                    </td>
                                    <td>
                                            <?= $this->Date->formatDate($program->date) ?>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <?= h($program->time) ?>
                                        </div>
                                    </td>
                                    <td>
                                        <?php if ($program->hasValue('program_status')): ?>
                                            <span class="badge bg-label-primary">
                                                    <?= $program->program_status->name ?>
                                                </span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        <nav aria-label="Page navigation">
                            <ul class="pagination justify-content-center">
                                <?= $this->Paginator->first('<i class="bx bx-chevrons-left"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                                <?= $this->Paginator->prev('<i class="bx bx-chevron-left"></i>', ['escape' => false, 'class' => 'page-item']) ?>

                                <?php
                                // Modify the default paginator to use Bootstrap classes
                                $this->Paginator->setTemplates([
                                    'number' => '<li class="page-item"><a class="page-link" href="{{url}}">{{text}}</a></li>',
                                    'current' => '<li class="page-item active"><a class="page-link" href="#">{{text}}</a></li>',
                                ]);

                                echo $this->Paginator->numbers();
                                ?>

                                <?= $this->Paginator->next('<i class="bx bx-chevron-right"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                                <?= $this->Paginator->last('<i class="bx bx-chevrons-right"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                            </ul>
                        </nav>
                        <div class="text-center text-muted mt-2">
                            <?= $this->Paginator->counter(('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
    
    const tbody = document.querySelector('tbody'); // Select the <tbody> element

    tbody.addEventListener('click', function(event) {
        // Make sure the clicked element is inside a row with the class 'clickable-row'
        const row = event.target.closest('.clickable-row');

        if (row) {
            const editUrl = row.getAttribute('data-edit-url');
            if (editUrl) {
                window.location.href = editUrl; // Redirect to the edit page
            }
        }
    });
});
</script>

