<!-- Content wrapper -->

<!-- Content -->
<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4">
        <span class="text-muted fw-light">Programs Students /</span> Listing
    </h4>

    <!-- Basic Layout -->
    <div class="row">
        <div class="col-xl">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <input
                        type="text"
                        class="mb-0"
                        placeholder="Search..."
                        aria-label="Search..."
                        style="margin-left: 20px; padding: 10px 15px; border-radius: 8px;"
                    />

                    <?= $this->Html->link(('New Programs Student'), ['action' => 'add'], ['class' => 'btn btn-primary']) ?>
                </div>
                <div class="card-body">
                    <div class="table-responsive text-nowrap">
                        <table class="table table-striped">
                            <thead>
                            <tr>
                                <th><?= $this->Paginator->sort('id') ?></th>
                                <th><?= $this->Paginator->sort('program_id') ?></th>
                                <th><?= $this->Paginator->sort('student_id') ?></th>
                                <th><?= $this->Paginator->sort('status') ?></th>
                                <th class="actions"><?= __('Actions') ?></th>
                            </tr>
                            </thead>
                            <tbody class="table-border-bottom-0">
                            <?php foreach ($programsStudents as $programsStudent): ?>
                                <tr>
                                    <td><?= $this->Number->format($programsStudent->id) ?></td>
                                    <td>
                                        <?php if ($programsStudent->hasValue('program')): ?>
                                            <div class="d-flex align-items-center">
                                                <i class="bx bx-calendar-event me-1"></i>
                                                <?= $this->Html->link(
                                                    $programsStudent->program->name,
                                                    ['controller' => 'Programs', 'action' => 'view', $programsStudent->program->id],
                                                    ['class' => 'text-decoration-none']
                                                ) ?>
                                            </div>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if ($programsStudent->hasValue('student')): ?>
                                            <div class="d-flex align-items-center">
                                                <i class="bx bx-user me-1"></i>
                                                <?= $this->Html->link(
                                                    $programsStudent->student->first_name,
                                                    ['controller' => 'Students', 'action' => 'view', $programsStudent->student->id],
                                                    ['class' => 'text-decoration-none']
                                                ) ?>
                                            </div>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                            <span
                                                class="badge bg-label-<?= strtolower($programsStudent->status) === 'active' ? 'success' : 'warning' ?>">
                                                <?= h($programsStudent->status) ?>
                                            </span>
                                    </td>
                                    <td class="actions">
                                        <div class="dropdown">
                                            <button type="button"
                                                    class="btn p-0 dropdown-toggle hide-arrow"
                                                    data-bs-toggle="dropdown">
                                                <i class="bx bx-dots-vertical-rounded"></i>
                                            </button>
                                            <div class="dropdown-menu">
                                                <?= $this->Html->link(
                                                    '<i class="bx bx-show-alt me-1"></i> View',
                                                    ['action' => 'view', $programsStudent->id],
                                                    ['class' => 'dropdown-item', 'escape' => false]
                                                ) ?>
                                                <?= $this->Html->link(
                                                    '<i class="bx bx-edit-alt me-1"></i> Edit',
                                                    ['action' => 'edit', $programsStudent->id],
                                                    ['class' => 'dropdown-item', 'escape' => false]
                                                ) ?>
                                                <?= $this->Form->postLink(
                                                    '<i class="bx bx-trash me-1"></i> Delete',
                                                    ['action' => 'delete', $programsStudent->id],
                                                    [
                                                        'confirm' => __('Are you sure you want to delete # {0}?', $programsStudent->id),
                                                        'class' => 'dropdown-item text-danger',
                                                        'escape' => false
                                                    ]
                                                ) ?>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        <nav aria-label="Page navigation">
                            <ul class="pagination justify-content-center">
                                <?= $this->Paginator->first('<i class="bx bx-chevrons-left"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                                <?= $this->Paginator->prev('<i class="bx bx-chevron-left"></i>', ['escape' => false, 'class' => 'page-item']) ?>

                                <?php
                                // Modify the default paginator to use Bootstrap classes
                                $this->Paginator->setTemplates([
                                    'number' => '<li class="page-item"><a class="page-link" href="{{url}}">{{text}}</a></li>',
                                    'current' => '<li class="page-item active"><a class="page-link" href="#">{{text}}</a></li>',
                                ]);

                                echo $this->Paginator->numbers();
                                ?>

                                <?= $this->Paginator->next('<i class="bx bx-chevron-right"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                                <?= $this->Paginator->last('<i class="bx bx-chevrons-right"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                            </ul>
                        </nav>
                        <div class="text-center text-muted mt-2">
                            <?= $this->Paginator->counter(('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
