<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\ProgramsStudent $programsStudent
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Programs Student'), ['action' => 'edit', $programsStudent->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Programs Student'), ['action' => 'delete', $programsStudent->id], ['confirm' => __('Are you sure you want to delete # {0}?', $programsStudent->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Programs Students'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Programs Student'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="programsStudents view content">
            <h3><?= h($programsStudent->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('Program') ?></th>
                    <td><?= $programsStudent->hasValue('program') ? $this->Html->link($programsStudent->program->name, ['controller' => 'Programs', 'action' => 'view', $programsStudent->program->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Student') ?></th>
                    <td><?= $programsStudent->hasValue('student') ? $this->Html->link($programsStudent->student->first_name, ['controller' => 'Students', 'action' => 'view', $programsStudent->student->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Status') ?></th>
                    <td><?= h($programsStudent->status) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($programsStudent->id) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>