<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\StudentStatus $studentStatus
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Student Status'), ['action' => 'edit', $studentStatus->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Student Status'), ['action' => 'delete', $studentStatus->id], ['confirm' => __('Are you sure you want to delete # {0}?', $studentStatus->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Student Statuses'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Student Status'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="studentStatuses view content">
            <h3><?= h($studentStatus->name) ?></h3>
            <table>
                <tr>
                    <th><?= __('Name') ?></th>
                    <td><?= h($studentStatus->name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($studentStatus->id) ?></td>
                </tr>
            </table>
            <div class="related">
                <h4><?= __('Related Students') ?></h4>
                <?php if (!empty($studentStatus->students)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('First Name') ?></th>
                            <th><?= __('Last Name') ?></th>
                            <th><?= __('Year Level') ?></th>
                            <th><?= __('School') ?></th>
                            <th><?= __('Contact First Name') ?></th>
                            <th><?= __('Contact Last Name') ?></th>
                            <th><?= __('Contact Phone') ?></th>
                            <th><?= __('Registration Date') ?></th>
                            <th><?= __('Student Status Id') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($studentStatus->students as $student) : ?>
                        <tr>
                            <td><?= h($student->id) ?></td>
                            <td><?= h($student->first_name) ?></td>
                            <td><?= h($student->last_name) ?></td>
                            <td><?= h($student->year_level) ?></td>
                            <td><?= h($student->school) ?></td>
                            <td><?= h($student->contact_first_name) ?></td>
                            <td><?= h($student->contact_last_name) ?></td>
                            <td><?= h($student->contact_phone) ?></td>
                            <td><?= h($student->registration_date) ?></td>
                            <td><?= h($student->student_status_id) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'Students', 'action' => 'view', $student->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'Students', 'action' => 'edit', $student->id]) ?>
                                <?= $this->Form->postLink(
                                    __('Delete'),
                                    ['controller' => 'Students', 'action' => 'delete', $student->id],
                                    [
                                        'method' => 'delete',
                                        'confirm' => __('Are you sure you want to delete # {0}?', $student->id),
                                    ]
                                ) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>