<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Student $student
 * @var string[]|\Cake\Collection\CollectionInterface $programs
 */
?>

<style>
    .switch {
        position: relative;
        display: inline-block;
        width: 50px;
        height: 30px;
    }

    /* Hide the default checkbox */
    .switch input {
        opacity: 0;
        width: 0;
        height: 0;
    }

    /* The slider (background) */
    .slider {
        position: absolute;
        cursor: pointer;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: #ccc;
        transition: .4s;
        border-radius: 30px;
    }

    /* The circle inside the slider */
    .slider:before {
        position: absolute;
        content: "";
        height: 22px;
        width: 22px;
        border-radius: 50%;
        left: 4px;
        bottom: 4px;
        background-color: white;
        transition: .4s;
    }

    /* When the checkbox is checked, change the background and the circle */
    input:checked + .slider {
        background-color: #4CAF50; /* Light green when checked */
    }

    input:checked + .slider:before {
        transform: translateX(20px); /* Move the circle to the right */
    }

    /* Disabled toggle looks gray and doesn't interact */
    input:disabled + .slider {
        background-color: #ccc;
    }

    input:disabled + .slider:before {
        background-color: #f1f1f1;
    }

    .program-checkbox {
    position: absolute;
    opacity: 0; /* Hide the default checkbox */
    width: 0;
    height: 0;
    }

    /* Style the custom checkbox */
    .program-checkbox + label {
        position: relative;
        padding-left: 35px; /* Space between checkbox and label */
        font-size: 16px; /* Font size for the program name */
        cursor: pointer;
        line-height: 1.5;
        color: #333;
        transition: color 0.3s ease;
    }

    /* Custom checkbox appearance */
    .program-checkbox + label::before {
        content: "";
        position: absolute;
        left: 0;
        top: 0;
        width: 25px;  /* Adjust the size */
        height: 25px;  /* Adjust the size */
        border: 2px solid #ccc;  /* Light border */
        border-radius: 4px;  /* Rounded corners */
        background-color: #fff;  /* White background */
        transition: all 0.3s ease;  /* Smooth transition */
    }

    /* Change the background when checked */
    .program-checkbox:checked + label::before {
        background-color: #28a745;  /* Light green background when checked */
        border-color: #28a745;  /* Green border when checked */
    }

    /* Add a checkmark when checked */
    .program-checkbox:checked + label::after {
        content: '\2713';  /* Checkmark symbol */
        position: absolute;
        left: 4px;
        top: 0px;
        font-size: 18px;
        color: white;
    }

    /* Hover effect for label */
    .program-checkbox + label:hover {
        color: #28a745;  /* Green color on hover */
    }

    /* Focus effect (when the checkbox is focused) */
    .program-checkbox:focus + label {
        outline: none;
        box-shadow: 0 0 2px 2px rgba(40, 167, 69, 0.5);  /* Light green outline when focused */
    }
</style>

<div class="container-xxl flex-grow-1 container-p-y">


    <div class="row">
        <!-- Form Card -->
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Edit Student</h5>
                    <div>
                        <?= $this->Html->link(
                            '<i class="bx bx-arrow-back me-1"></i> Back to Students',
                            ['action' => 'index'],
                            ['class' => 'btn btn-secondary btn-sm', 'escape' => false]
                        ) ?>
                        <?= $this->Form->postLink(
                            '<i class="bx bx-trash me-1"></i> Delete Student',
                            ['action' => 'delete', $student->id],
                            [
                                'confirm' => __('Are you sure you want to delete # {0}?', $student->id),
                                'class' => 'btn btn-danger btn-sm ms-2',
                                'escape' => false
                            ]
                        ) ?>
                    </div>
                </div>
                <div class="card-body">
                <?= $this->Flash->render() ?>
                <?php if ($student->getErrors()): ?>
                    <div class="alert alert-danger">
                        <ul>
                            <?php foreach ($student->getErrors() as $field => $errors): ?>
                                <?php foreach ($errors as $error): ?>
                                    <li><?= h($error) ?></li>
                                <?php endforeach; ?>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>
                    <?= $this->Form->create($student, ['class' => 'row g-3']) ?>

                    <!-- Personal Information -->
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="name">Student Name</label>
                            <?= $this->Form->control('name', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter first name',
                                'required' => true,
                            ]) ?>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="year_level">Year Level</label>
                            <?= $this->Form->control('year_level', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Year Level',
                                'required' => true,
                            ]) ?>
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="form-group mb-3">
                            <label class="form-label" for="school">School</label>
                            <?= $this->Form->control('school', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter school name',
                                'required' => true,
                            ]) ?>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="contact_name">Registrar Name</label>
                            <?= $this->Form->control('contact_name', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter name',
                                'required' => true,
                            ]) ?>
                        </div>
                    </div>

                    <!-- Contact Information -->
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="contact_email">Registrar Email</label>
                            <?= $this->Form->control('contact_email', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'example@example.com',
                                'type' => 'email',
                                'required' => true,
                            ]) ?>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="contact_phone">Registrar Phone</label>
                            <?= $this->Form->control('contact_phone', [
                              'class' => 'form-control',
                              'placeholder' => 'Enter your phone number',
                              'label' => false,
                              'required' => true,
                              'pattern' => '^[0-9]{10}$',
                              'title' => 'Phone number must be exactly 10 digits'
                          ]) ?>
                        </div>
                    </div>



               <!-- Programs -->
               <div class="col-12">
    <div class="form-group mb-3">
        
        <table id="programsTable" class="table">
            <thead>
                <tr>
                    <th>Interested Programs</th>
                    <th>Registered</th>
                </tr>
            </thead>
            <tbody>
            <?php foreach ($programs as $program_id => $program_name): ?>
                <tr data-program-id="<?= h($program_id) ?>" class="program-row">
                <td>
    <input type="checkbox" id="program-<?= h($program_id) ?>" name="programs[]" value="<?= h($program_id) ?>" 
        class="program-checkbox"
        <?= in_array($program_id, array_column($student->programs, 'id')) ? 'checked' : '' ?> 
    >
    <label for="program-<?= h($program_id) ?>"><?= h($program_name) ?></label>
</td>
                    <td>
                        <label class="switch">
                            <input type="checkbox" name="program_status[<?= h($program_id) ?>]" 
                                class="toggle-checkbox program-status-toggle" 
                                <?php
                                // Use programStatuses to check the program status for each program
                                if (isset($programStatuses[$program_id]) && $programStatuses[$program_id] == 1) {
                                    echo 'checked';
                                }
                                ?>
                                disabled
                                data-program-id="<?= h($program_id) ?>"  
                            >
                            <span class="slider round"></span>
                        </label>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<div class="col-12">
    <hr class="my-4">
    <?= $this->Form->button(__('Save Changes'), [
        'class' => 'btn btn-primary me-2'
    ]) ?>

    <?= $this->Html->link(
        __('Cancel'),
        ['action' => 'index'],
        ['class' => 'btn btn-outline-secondary']
    ) ?>
</div>
<?= $this->Form->end() ?>


<script>
    document.addEventListener("DOMContentLoaded", function () {
        const programCheckboxes = document.querySelectorAll('.program-checkbox');
        const statusCheckboxes = document.querySelectorAll('.program-status-toggle');

        programCheckboxes.forEach(function (checkbox) {
            checkbox.addEventListener('change', function () {
                const row = this.closest('tr');
                const toggle = row.querySelector('.program-status-toggle');
                
                // Show/hide and enable/disable the toggle based on the checkbox state
                if (this.checked) {
                    toggle.disabled = false;  // Enable the toggle if the program is selected
                    toggle.closest('td').style.display = 'table-cell'; // Make status cell visible
                } else {
                    toggle.disabled = true;   // Disable the toggle if the program is not selected
                    toggle.closest('td').style.display = 'none'; // Hide status cell when unchecked
                }
            });

            // Initial check on page load for already checked checkboxes
            if (checkbox.checked) {
                const row = checkbox.closest('tr');
                const toggle = row.querySelector('.program-status-toggle');
                toggle.disabled = false;
                toggle.closest('td').style.display = 'table-cell'; // Make the status cell visible if checked
            } else {
                const row = checkbox.closest('tr');
                const toggle = row.querySelector('.program-status-toggle');
                toggle.disabled = true;
                toggle.closest('td').style.display = 'none'; // Hide status cell if unchecked
            }
        });

        // Handle the appearance of the toggle when clicked
        statusCheckboxes.forEach(function (toggle) {
            toggle.addEventListener('change', function () {
                // Change the color when clicked (handled by CSS already)
                if (this.checked) {
                    this.parentElement.querySelector('.slider').style.backgroundColor = "#4CAF50"; // Green
                } else {
                    this.parentElement.querySelector('.slider').style.backgroundColor = "#ccc"; // Default gray
                }
            });
        });
    });

</script>
