<!-- Content -->
<div class="container-xxl flex-grow-1 container-p-y">
    <!-- Upload Modal -->
    <div class="modal fade" id="uploadModal" tabindex="-1" aria-labelledby="uploadModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="uploadModalLabel">Upload File</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <?= $this->Form->create(null, ['type' => 'file', 'url' => ['action' => 'upload'], 'id' => 'uploadForm']) ?>
                    <div class="mb-3">
                        <label for="fileInput" class="form-label">Select Excel File</label>
                        <?= $this->Form->file('uploaded_file', [
                            'class' => 'form-control',
                            'id' => 'fileInput',
                            'required' => true,
                            'accept' => '.csv'
                        ]) ?>
                        <small class="form-text text-muted">Accepted formats: <span style="color: #f3884a">.csv</span> only </small>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Sample Data Format</label>
                        <div class="image-container">
                            <img src="<?= $this->Url->build('/img/studentdata.png') ?>" alt="Student Sample" class="img-fluid">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <?= $this->Form->button('Upload', [
                        'type' => 'submit',
                        'class' => 'btn btn-primary',
                        'id' => 'uploadButton'
                    ]) ?>
                    <?= $this->Form->end() ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="row">
        <div class="col-xl">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
<!--                    <input-->
<!--                        type="text"-->
<!--                        id="search-bar"-->
<!--                        class="form-control"-->
<!--                        placeholder="Search..."-->
<!--                        aria-label="Search..."-->
<!--                        style="max-width: 300px; border-radius: 8px;"-->
<!--                    >-->
                    <div></div>
                    <div>
                        <?= $this->Html->link(
                            'Export CSV',
                            ['action' => 'overview'],
                            ['class' => 'btn btn-outline-primary me-2']
                        ) ?>
                        <?= $this->Html->link(
                            'Upload File',
                            '#',
                            [
                                'class' => 'btn btn-outline-primary me-2',
                                'data-bs-toggle' => 'modal',
                                'data-bs-target' => '#uploadModal'
                            ]
                        ) ?>
                        <?= $this->Html->link(
                            'New Student',
                            ['action' => 'add'],
                            ['class' => 'btn btn-primary']
                        ) ?>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Rest of the existing table and pagination code remains the same -->
                    <div class="table-responsive text-nowrap">
                        <table class="table table-striped">
                            <thead>
                            <tr>
                                <th><?= $this->Paginator->sort('name') ?></th>
                                <th><?= $this->Paginator->sort('year_level', 'Year Level', ['order' => 'ASC'], ['type' => 'numeric']) ?></th>
                                <th><?= $this->Paginator->sort('school') ?></th>
                                <th><?= $this->Paginator->sort('registration_date') ?></th>
                                <th><?= $this->Paginator->sort('student_status_id') ?></th>
                            </tr>
                            </thead>
                            <tbody class="table-border-bottom-0">
                            <?php foreach ($students as $student): ?>
                                <tr data-edit-url="<?= $this->Url->build(['controller' => 'Students', 'action' => 'edit', $student->id]) ?>" class="clickable-row">
                                    <td>
                                         <?= h($student->name) ?>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <?= h($student->year_level) ?>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <?= h($student->school) ?>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <i class="bx bx-time me-1"></i>
                                            <?= $this->Date->formatDate($student->registration_date) ?>
                                        </div>
                                    </td>
                                    <td>
                                        <?php if ($student->hasValue('student_status')):
                                            switch ($student->student_status_id) {
                                                case 0:
                                                    $iconPath = 'img/new-icon.png';
                                                    break;
                                                case 1:
                                                    $iconPath = 'img/done-icon.png';
                                                    break;
                                                case 2:
                                                    $iconPath = 'img/alert-icon.png';
                                                    break;
                                                case 3:
                                                    $iconPath = 'img/inactive-icon.png';
                                                    break;
                                                default:
                                                    $iconPath = 'img/default-icon.png';
                                            }?>
                                            <img src="<?= $this->Url->assetUrl($iconPath) ?>" alt="Status Icon" width="24" height="24" />
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination remains the same -->
                    <div class="mt-4">
                        <nav aria-label="Page navigation">
                            <ul class="pagination justify-content-center">
                                <?= $this->Paginator->first('<i class="bx bx-chevrons-left"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                                <?= $this->Paginator->prev('<i class="bx bx-chevron-left"></i>', ['escape' => false, 'class' => 'page-item']) ?>

                                <?php
                                $this->Paginator->setTemplates([
                                    'number' => '<li class="page-item"><a class="page-link" href="{{url}}">{{text}}</a></li>',
                                    'current' => '<li class="page-item active"><a class="page-link" href="#">{{text}}</a></li>',
                                ]);

                                echo $this->Paginator->numbers();
                                ?>

                                <?= $this->Paginator->next('<i class="bx bx-chevron-right"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                                <?= $this->Paginator->last('<i class="bx bx-chevrons-right"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                            </ul>
                        </nav>
                        <div class="text-center text-muted mt-2">
                            <?= $this->Paginator->counter(('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const uploadForm = document.getElementById('uploadForm');
        const uploadModal = new bootstrap.Modal(document.getElementById('uploadModal'));

        uploadForm.addEventListener('submit', function (event) {
            // Optional: Add validation or loading state here if needed
            setTimeout(() => {
                uploadModal.hide();
            }, 500); // Delay to ensure form submission starts before modal closes
        });

        document.querySelectorAll('.clickable-row').forEach(function(row) {
            row.addEventListener('click', function() {
                var editUrl = row.getAttribute('data-edit-url');
                if (editUrl) {
                    window.location.href = editUrl;
                }
            });
        });
    });
</script>
