<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Student> $students
 * @var string|null $start
 * @var string|null $end
 */
?>
<div class="container-xxl flex-grow-2 container-p-y">
    <div class="row">
        <div class="col-xl">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">CSV Preview (<?= h($start) ?> → <?= h($end) ?>)</h5>
                    <div>
                        <?= $this->Html->link(
                            __('Back to Overview'),
                            ['action' => 'overview', '?' => ['start_date' => $start, 'end_date' => $end]],
                            ['class' => 'btn btn-outline-secondary me-2']
                        ) ?>
                        <?= $this->Html->link(
                            __('Download CSV'),
                            ['action' => 'export', '?' => ['start_date' => $start, 'end_date' => $end]],
                            ['class' => 'btn btn-outline-success']
                        ) ?>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive text-nowrap">
                        <table class="table table-striped">
                            <thead>
                            <tr>
                                <th><?= $this->Paginator->sort('name', 'Name') ?></th>
                                <th><?= $this->Paginator->sort('year_level', 'Year Level') ?></th>
                                <th><?= $this->Paginator->sort('school', 'School') ?></th>
                                <th><?= $this->Paginator->sort('contact_name', 'Contact Name') ?></th>
                                <th><?= $this->Paginator->sort('contact_phone', 'Contact Phone') ?></th>
                                <th><?= $this->Paginator->sort('registration_date', 'Registration Date') ?></th>
                                <th><?= $this->Paginator->sort('status', 'Status') ?></th>
                                <th><?= $this->Paginator->sort('contact_email', 'Contact Email') ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($students as $s): ?>
                                <tr>
                                    <td><?= h($s->name) ?></td>
                                    <td><?= h($s->year_level) ?></td>
                                    <td><?= h($s->school) ?></td>
                                    <td><?= h($s->contact_name) ?></td>
                                    <td><?= h($s->contact_phone) ?></td>
                                    <td><?= $s->registration_date?->format('Y-m-d') ?></td>
                                    <td><?= h($s->status) ?></td>
                                    <td><?= h($s->contact_email) ?></td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <nav aria-label="Page navigation" class="mt-4">
                        <ul class="pagination justify-content-center">
                            <?= $this->Paginator->first('', ['class' => 'page-item', 'escape' => false]) ?>
                            <?= $this->Paginator->prev('', ['class' => 'page-item', 'escape' => false]) ?>
                            <?= $this->Paginator->numbers() ?>
                            <?= $this->Paginator->next('', ['class' => 'page-item', 'escape' => false]) ?>
                            <?= $this->Paginator->last('', ['class' => 'page-item', 'escape' => false]) ?>
                        </ul>
                        <div class="text-center text-muted mt-2">
                            <?= $this->Paginator->counter() ?>
                        </div>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</div>
