<?php
use Cake\Core\Configure;
use Cake\Http\Exception\NotFoundException;

$this->disableAutoLayout();

?>
<!DOCTYPE html>
<html>
<head>
    <?= $this->Html->charset() ?>
    <?= $this->Html->meta('viewport', 'width=device-width, initial-scale=1.0') ?>
    <link rel="icon" href="<?= $this->Url->image('favicon.ico') ?>" type="image/x-icon">

    <title>VIC Selective Entrance High Schools Exam in <?= date('Y') ?></title>

    <?= $this->Html->css([
        'https://fonts.googleapis.com/css2?family=Roboto&display=swap',
        'vendor/bootstrap/css/bootstrap.min.css',
        'vendor/bootstrap-icons/bootstrap-icons.css',
        'vendor/aos/aos.css',
        'vendor/glightbox/css/glightbox.min.css',
        'vendor/swiper/swiper-bundle.min.css'
    ], ['pathPrefix' => 'assets/']) ?>

    <?= $this->Html->css('main.css', ['pathPrefix' => 'assets/css/']) ?>
</head>

<body class="index-page">

<?= $this->element('header'); ?>

<main class="main section py-5">
    <div class="container py-5" data-aos="fade-up">
    <h1 class="text-center mb-5">Explore - Our Program - <?= date('Y') ?></h1>
        <ul class="mb-4">
        <div class="mb-4">
    <?= $this->ContentBlock->html('explore-program-2025-description'); ?>
    <?= $this->ContentBlock->html('explore-program-2025-features'); ?>
</div>

        </ul>
        <div class="text-center">
            <a href="<?= $this->Url->build('/student-register', ['fullBase' => true]) ?>" class="btn btn-primary">Register now</a>
        </div>
    </div>

    <div class="container py-5" data-aos="fade-up">
        <h2 class="text-center mb-4">Our Teachers</h2>
        <ul class="mb-0">
        <?= $this->ContentBlock->html('our-teachers'); ?>
        </ul>
    </div>

    <div class="container py-5" data-aos="fade-up">
        <h2 class="text-center mb-4">Our Year-Level Programs</h2>
        <div class="row g-4">
            <div class="col-md-6">
                <div class="card h-100 p-4 shadow-sm border-0">
                    <h3>Year 7 Program</h3>
                    <p><?= strip_tags($this->ContentBlock->html('year-7-program-description')); ?></p>
                    <a href="<?= $this->Url->build('/year7-program') ?>" class="btn btn-outline-primary">Explore the Year 7 Program</a>
        
                </div>
            </div>
            <div class="col-md-6">
                <div class="card h-100 p-4 shadow-sm border-0">
                    <h3>Year 8 Program</h3>
                    <p><?= strip_tags($this->ContentBlock->html('year-8-program-description')); ?></p>
                    <a href="<?= $this->Url->build('/year8-program') ?>" class="btn btn-outline-primary">Explore the Year 8 Program</a>                </div>
            </div>
        </div>

    </div>
</main>

<?= $this->element('footer'); ?>

<a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center">
    <i class="bi bi-arrow-up-short"></i>
</a>

<script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="assets/vendor/php-email-form/validate.js"></script>
<script src="assets/vendor/aos/aos.js"></script>
<script src="assets/vendor/waypoints/noframework.waypoints.js"></script>
<script src="assets/vendor/glightbox/js/glightbox.min.js"></script>
<script src="assets/vendor/imagesloaded/imagesloaded.pkgd.min.js"></script>
<script src="assets/vendor/isotope-layout/isotope.pkgd.min.js"></script>
<script src="assets/vendor/swiper/swiper-bundle.min.js"></script>
<script src="assets/js/main.js"></script>

</body>
</html>
