<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\VolunteerStatus> $volunteerStatuses
 */
?>
<div class="content-wrapper">


    <!-- Basic Layout -->
    <div class="row">
        <div class="col-xl">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">

                    <div class="volunteer-status">
<!--                        <h4 class="volunteer-status-title">Volunteer Status</h4>-->
                    </div>
                    <?= $this->Html->link('New Volunteer Status', ['action' => 'add'], ['class' => 'btn btn-primary']) ?>
                </div>
                <div class="card-body">
                    <div class="table-responsive text-nowrap">
                        <table class="table table-striped">
                            <thead>
                            <tr>
                                <!--                                    <th>-->
                                <?php //= $this->Paginator->sort('id') ?><!--</th>-->
                                <th><?= $this->Paginator->sort('name') ?></th>
                            </tr>
                            </thead>
                            <tbody class="table-border-bottom-0">
                            <?php foreach ($volunteerStatuses as $status): ?>
                                <tr data-edit-url="<?= $this->Url->build(['controller' => 'VolunteerStatuses', 'action' => 'edit', $status->id]) ?>" class="clickable-row">
                                 <!--                                        <td>-->
                                    <?php //= $this->Number->format($status->id) ?><!--</td>-->
                                    <!--                                        <td>-->
                                    <?php //= h($status->name) ?><!--</td>-->
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <!--                                                            <i class="bx bx-tag me-1"></i>-->
                                            <span class="badge bg-label-info"><?= h($status->name) ?></span>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        <nav aria-label="Page navigation">
                            <ul class="pagination justify-content-center">
                                <?= $this->Paginator->first('<i class="bx bx-chevrons-left"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                                <?= $this->Paginator->prev('<i class="bx bx-chevron-left"></i>', ['escape' => false, 'class' => 'page-item']) ?>

                                <?php
                                $this->Paginator->setTemplates([
                                    'number' => '<li class="page-item"><a class="page-link" href="{{url}}">{{text}}</a></li>',
                                    'current' => '<li class="page-item active"><a class="page-link" href="#">{{text}}</a></li>',
                                ]);
                                echo $this->Paginator->numbers();
                                ?>

                                <?= $this->Paginator->next('<i class="bx bx-chevron-right"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                                <?= $this->Paginator->last('<i class="bx bx-chevrons-right"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                            </ul>
                        </nav>
                        <div class="text-center text-muted mt-2">
                            <?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- / Content -->
</div>

<style>
    .volunteer-status {
        margin-bottom: 20px; /* Adds space below the element */
        padding: 10px; /* Adds padding inside the container */
        background-color: #f4f4f4; /* Light gray background */
        border-radius: 8px; /* Rounded corners */
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1); /* Subtle shadow */
    }

    .volunteer-status-title {
        font-size: 24px; /* Larger font size */
        font-weight: bold; /* Bold font */
        color: #333; /* Dark text color */
        margin: 0; /* Remove default margin */
        text-transform: uppercase; /* Uppercase text */
        letter-spacing: 1px; /* Adds spacing between letters */
    }

</style>

<script>
    document.addEventListener('DOMContentLoaded', function () {
    
    const tbody = document.querySelector('tbody'); // Select the <tbody> element

    tbody.addEventListener('click', function(event) {
        // Make sure the clicked element is inside a row with the class 'clickable-row'
        const row = event.target.closest('.clickable-row');

        if (row) {
            const editUrl = row.getAttribute('data-edit-url');
            if (editUrl) {
                window.location.href = editUrl; // Redirect to the edit page
            }
        }
    });
});
</script>
