<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Volunteer $volunteer
 * @var \Cake\Collection\CollectionInterface|string[] $volunteerStatuses
 * @var \Cake\Collection\CollectionInterface|string[] $programs
 */
?>
<div class="container-xxl flex-grow-1 container-p-y">

    <div class="row">
        <!-- Form Card -->
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Add Volunteer</h5>
                    <?= $this->Html->link(
                        '<i class="bx bx-arrow-back me-1"></i> Back to Volunteers',
                        ['action' => 'index'],
                        ['class' => 'btn btn-secondary btn-sm', 'escape' => false]
                    ) ?>
                </div>
                <div class="card-body">
                    <?= $this->Form->create($volunteer, ['class' => 'row g-3']) ?>

                    <!-- Name Fields -->
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="first-name">First Name</label>
                            <?= $this->Form->control('first_name', [
                                'required' => true,
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter first name',
                                'id' => 'first-name'
                            ]) ?>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="last-name">Last Name</label>
                            <?= $this->Form->control('last_name', [
                                'required' => true,
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter last name',
                                'id' => 'last-name'
                            ]) ?>
                        </div>
                    </div>

                    <!-- Contact Information -->
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="email">Email Address</label>
                            <?= $this->Form->control('email', [
                                'required' => true,
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter email address',
                                'type' => 'email',
                                'id' => 'email'
                            ]) ?>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="phone">Phone Number</label>
                            <?= $this->Form->control('phone', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter phone number',
                                'id' => 'phone'
                            ]) ?>
                        </div>
                    </div>

                    <!-- Additional Information -->
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="postcode">Postcode</label>
                            <?= $this->Form->control('postcode', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter postcode',
                                'id' => 'postcode'
                            ]) ?>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="occupation">Occupation</label>
                            <?= $this->Form->control('occupation', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter occupation',
                                'id' => 'occupation'
                            ]) ?>
                        </div>
                    </div>

                    <!-- Description -->
                    <div class="col-12">
                        <div class="form-group mb-3">
                            <label class="form-label" for="description">Description</label>
                            <?= $this->Form->control('description', [
                                'type' => 'textarea',
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter additional information about the volunteer',
                                'rows' => 4,
                                'id' => 'description',
                                'required' => false
                            ]) ?>
                        </div>
                    </div>

                    <!-- Status and Programs -->
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="volunteer-status">Volunteer Status</label>
                            <?= $this->Form->control('volunteer_status_id', [
                                'options' => $volunteerStatuses,
                                'empty' => '-- Select Status --',
                                'class' => 'form-select',
                                'label' => false,
                                'id' => 'volunteer-status'
                            ]) ?>
                        </div>
                    </div>

<!--                    <div class="col-md-6">-->
<!--                        <div class="form-group mb-3">-->
<!--                            <label class="form-label" for="programs">Programs</label>-->
<!--                            --><?php //= $this->Form->control('programs._ids', [
//                                'options' => $programs,
//                                'class' => 'form-select',
//                                'label' => false,
//                                'multiple' => true,
//                                'id' => 'programs',
//                                'data-placeholder' => 'Select programs'
//                            ]) ?>
<!--                            <div class="form-text">-->
<!--                                Hold Ctrl (or Cmd) to select multiple programs-->
<!--                            </div>-->
<!--                        </div>-->
<!--                    </div>-->

                    <!-- Submit Buttons -->
                    <div class="col-12">
                        <hr class="my-4">
                        <?= $this->Form->button(__('Create Volunteer'), [
                            'class' => 'btn btn-primary me-2'
                        ]) ?>

                        <?= $this->Html->link(
                            __('Cancel'),
                            ['action' => 'index'],
                            ['class' => 'btn btn-outline-secondary']
                        ) ?>
                    </div>
                    <?= $this->Form->end() ?>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
document.addEventListener('DOMContentLoaded', () => {
    const textarea = document.getElementById('description');
    const wordCounter = document.createElement('div');
    wordCounter.id = 'word-counter';
    wordCounter.style.marginTop = '5px';
    wordCounter.style.fontSize = '0.9rem';
    wordCounter.style.color = '#555';
    textarea.parentNode.appendChild(wordCounter);

    textarea.addEventListener('input', () => {
        const words = textarea.value.trim().split(/\s+/);
        const wordCount = textarea.value.trim() ? words.length : 0;

        wordCounter.textContent = `Words: ${wordCount}/50`;

        if (wordCount >= 50) {
            const trimmed = words.slice(0, 50).join(' ');
            textarea.value = trimmed;
            wordCounter.textContent = 'Words: 50/50 (Maximum reached)';
            wordCounter.style.color = 'red';
        } else {
            wordCounter.style.color = '#555';
        }
    });
});
</script>


