<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Volunteer $volunteer
 * @var string[]|\Cake\Collection\CollectionInterface $volunteerStatuses
 * @var string[]|\Cake\Collection\CollectionInterface $programs
 */
?>
<div class="container-xxl flex-grow-1 container-p-y">


    <div class="row">
        <!-- Form Card -->
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Edit Volunteer</h5>
                    <div>
                        <?= $this->Html->link(
                            '<i class="bx bx-arrow-back me-1"></i> Back to Volunteers',
                            ['action' => 'index'],
                            ['class' => 'btn btn-secondary btn-sm', 'escape' => false]
                        ) ?>
                        <?= $this->Form->postLink(
                            '<i class="bx bx-trash me-1"></i> Delete Volunteer',
                            ['action' => 'delete', $volunteer->id],
                            [
                                'confirm' => __('Are you sure you want to delete # {0}?', $volunteer->id),
                                'class' => 'btn btn-danger btn-sm ms-2',
                                'escape' => false
                            ]
                        ) ?>
                    </div>
                </div>
                <div class="card-body">
                    <?= $this->Form->create($volunteer, ['class' => 'row g-3']) ?>

                    <!-- Personal Information -->
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="first-name">First Name</label>
                            <?= $this->Form->control('first_name', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter first name'
                            ]) ?>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="last-name">Last Name</label>
                            <?= $this->Form->control('last_name', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter last name'
                            ]) ?>
                        </div>
                    </div>

                    <!-- Contact Information -->
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="email">Email</label>
                            <?= $this->Form->control('email', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter email address',
                                'type' => 'email'
                            ]) ?>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="phone">Phone</label>
                            <?= $this->Form->control('phone', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter phone number'
                            ]) ?>
                        </div>
                    </div>

                    <!-- Additional Information -->
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="postcode">Postcode</label>
                            <?= $this->Form->control('postcode', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter postcode'
                            ]) ?>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="occupation">Occupation</label>
                            <?= $this->Form->control('occupation', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter occupation'
                            ]) ?>
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="form-group mb-3">
                            <label class="form-label" for="description">Description</label>
                            <?= $this->Form->control('description', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter description',
                                'rows' => 3
                            ]) ?>
                        </div>
                    </div>

                    <!-- Status -->
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="volunteer-status-id">Volunteer Status</label>
                            <?= $this->Form->control('volunteer_status_id', [
                                'options' => $volunteerStatuses,
                                'empty' => '-- Select Status --',
                                'class' => 'form-select',
                                'label' => false
                            ]) ?>
                        </div>
                    </div>

                    <!-- Programs -->
<!--                    <div class="col-12">-->
<!--                        <div class="form-group mb-3">-->
<!--                            <label class="form-label" for="programs-ids">Programs</label>-->
<!--                            --><?php //= $this->Form->control('programs._ids', [
//                                'options' => $programs,
//                                'class' => 'form-select',
//                                'label' => false,
//                                'multiple' => 'multiple',
//                                'data-placeholder' => 'Select programs',
//                                'style' => 'width: 100%'
//                            ]) ?>
<!--                            <small class="form-text text-muted">Hold Ctrl/Cmd to select multiple programs</small>-->
<!--                        </div>-->
<!--                    </div>-->

                    <div class="col-12">
                        <hr class="my-4">
                        <?= $this->Form->button(__('Save Changes'), [
                            'class' => 'btn btn-primary me-2'
                        ]) ?>

                        <?= $this->Html->link(
                            __('Cancel'),
                            ['action' => 'index'],
                            ['class' => 'btn btn-outline-secondary']
                        ) ?>
                    </div>
                    <?= $this->Form->end() ?>
                </div>
            </div>
        </div>
    </div>
</div>
