<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Volunteer> $volunteers
 */
?>
<!-- Content -->
<div class="container-xxl flex-grow-2 container-p-y">

    <!-- Upload Modal -->
    <div class="modal fade" id="uploadModal" tabindex="-1" aria-labelledby="uploadModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="uploadModalLabel">Upload File</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <?= $this->Form->create(null, ['type' => 'file', 'url' => ['action' => 'upload'], 'id' => 'uploadForm']) ?>
                    <div class="mb-3">
                        <label for="fileInput" class="form-label">Select Excel File</label>
                        <?= $this->Form->file('uploaded_file', [
                            'class' => 'form-control',
                            'id' => 'fileInput',
                            'required' => true,
                            'accept' => '.csv'
                        ]) ?>
                        <small class="form-text text-muted">Accepted formats: <span style="color: #f3884a">.csv</span> only </small>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Sample Data Format</label>
                        <div class="image-container">
                            <img src="<?= $this->Url->build('/img/volunteerdample.png') ?>" alt="Volunteer Image" class="img-fluid">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <?= $this->Form->button('Upload', [
                        'type' => 'submit',
                        'class' => 'btn btn-primary',
                        'id' => 'uploadButton'
                    ]) ?>
                    <?= $this->Form->end() ?>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-xl">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <div></div>
                    <div>
                        <?= $this->Html->link(
                            'Export CSV',
                            ['action' => 'overview'],
                            ['class' => 'btn btn-outline-primary me-2']
                        ) ?>
                        <?= $this->Html->link(
                            'Upload File',
                            '#',
                            [
                                'class' => 'btn btn-primary',
                                'data-bs-toggle' => 'modal',
                                'data-bs-target' => '#uploadModal'
                            ]
                        ) ?>
                        <?= $this->Html->link(('Add Volunteer'), ['action' => 'add'], ['class' => 'btn btn-primary']) ?>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive text-nowrap">
                        <table class="table table-striped">
                            <thead>
                            <tr>
                                <th><?= $this->Paginator->sort('name') ?></th>
                                <th><?= $this->Paginator->sort('email') ?></th>
                                <th><?= $this->Paginator->sort('phone') ?></th>
                                <th><?= $this->Paginator->sort('postcode') ?></th>
                                <th><?= $this->Paginator->sort('occupation') ?></th>
                                <th><?= $this->Paginator->sort('volunteer_status_id') ?></th>
                            </tr>
                            </thead>
                            <tbody class="table-border-bottom-0">
                            <?php foreach ($volunteers as $volunteer): ?>
                                <tr data-edit-url="<?= $this->Url->build(['controller' => 'Volunteers', 'action' => 'edit', $volunteer->id]) ?>" class="clickable-row">
                                    <td><?= h($volunteer->first_name . ' ' . $volunteer->last_name) ?></td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <a href="mailto:<?= h($volunteer->email) ?>"
                                               style="text-decoration: underline; color: orange;">
                                                <?= h($volunteer->email) ?>
                                            </a>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <a href="tel:<?= h($volunteer->phone) ?>" style="text-decoration: underline; color: orange;">
                                                <?= h($volunteer->phone) ?>
                                            </a>
                                        </div>
                                    </td>
                                    <td><?= h($volunteer->postcode) ?></td>
                                    <td><?= h($volunteer->occupation) ?></td>
                                    <td>
                                        <?php if ($volunteer->hasValue('volunteer_status')): ?>
                                            <span class="badge bg-label-primary">
                                                <?= $volunteer->volunteer_status->name ?>
                                            </span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        <nav aria-label="Page navigation">
                            <ul class="pagination justify-content-center">
                                <?= $this->Paginator->first('<i class="bx bx-chevrons-left"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                                <?= $this->Paginator->prev('<i class="bx bx-chevron-left"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                                <?php
                                $this->Paginator->setTemplates([
                                    'number' => '<li class="page-item"><a class="page-link" href="{{url}}">{{text}}</a></li>',
                                    'current' => '<li class="page-item active"><a class="page-link" href="#">{{text}}</a></li>',
                                ]);
                                echo $this->Paginator->numbers();
                                ?>
                                <?= $this->Paginator->next('<i class="bx bx-chevron-right"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                                <?= $this->Paginator->last('<i class="bx bx-chevrons-right"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                            </ul>
                        </nav>
                        <div class="text-center text-muted mt-2">
                            <?= $this->Paginator->counter(('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .download-container {
        text-align: center;
        margin: 20px;
    }
    .download-link {
        display: inline-block;
        padding: 12px 20px;
        background-color: #f85c01;
        color: white;
        font-size: 16px;
        text-decoration: none;
        border-radius: 8px;
        transition: background-color 0.3s ease, transform 0.2s;
    }
    .download-link:hover {
        background-color: #c64f08;
        color: white;
        transform: scale(1.05);
    }
    .download-icon {
        margin-right: 8px;
    }
</style>

<!-- Add JavaScript at the bottom -->
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const uploadForm = document.getElementById('uploadForm');
        const uploadModal = new bootstrap.Modal(document.getElementById('uploadModal'));

        uploadForm.addEventListener('submit', function (event) {
            // Optional: Add validation or loading state here if needed
            setTimeout(() => {
                uploadModal.hide();
            }, 500); // Delay to ensure form submission starts before modal closes
        });
    });


    document.addEventListener('DOMContentLoaded', function () {

    const tbody = document.querySelector('tbody'); // Select the <tbody> element

    tbody.addEventListener('click', function(event) {
        // Make sure the clicked element is inside a row with the class 'clickable-row'
        const row = event.target.closest('.clickable-row');

        if (row) {
            const editUrl = row.getAttribute('data-edit-url');
            if (editUrl) {
                window.location.href = editUrl; // Redirect to the edit page
            }
        }
    });
});
</script>

