<?php ?>

<div class="container1">
    <h1>Empower the Next Generation of Innovators</h1>
    <p class="subheadline">Your donation helps young Australians gain critical STEM skills.</p>

    <!-- Donation Form -->
    <form>
        <div class="donation-options">
            <label><input type="radio" name="amount" value="25"><span>$10</span></label>
            <label><input type="radio" name="amount" value="25"><span>$25</span></label>
            <label><input type="radio" name="amount" value="50" checked><span>$50</span></label>
            <label><input type="radio" name="amount" value="100"><span>$100</span></label>
            <label><input type="radio" name="amount" value="250"><span>$250</span></label>
        </div>

        <button type="submit" class="submit-btn">Complete My Donation</button>
    </form>

    <!-- Impact Section -->
    <div class="impact-section">
        <h2>What Your Donation Does</h2>
        <div class="impact-grid">
            <div class="impact-item">
                <strong>$25</strong><br>Provides materials for a student’s STEM project.
            </div>
            <div class="impact-item">
                <strong>$50</strong><br>Funds a coding workshop for 5 young innovators.
            </div>
            <div class="impact-item">
                <strong>$100</strong><br>Supports a mentor to guide students.
            </div>
        </div>
    </div>
</div>
<style>
    body {
        font-family: 'Roboto', sans-serif;
        background-color: #f5f5f5;
        margin: 0;
        padding: 20px;
        color: #333;
    }

    .container1 {
        max-width: 600px;
        margin: 40px auto;
        background: #fff;
        padding: 30px;
        border-radius: 10px;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }

    h1 {
        color: #1e90ff;
        text-align: center;
        font-size: 28px;
        margin-bottom: 10px;
    }

    .subheadline {
        text-align: center;
        font-size: 16px;
        color: #666;
        margin-bottom: 30px;
    }

    .donation-options {
        display: flex;
        justify-content: space-between;
        flex-wrap: wrap;
        gap: 10px;
        margin-bottom: 20px;
    }

    .donation-options label {
        flex: 1;
        min-width: 80px;
        text-align: center;
    }

    .donation-options input[type="radio"] {
        display: none;
    }

    .donation-options input[type="radio"] + span {
        display: block;
        padding: 10px;
        background: #e0e0e0;
        border-radius: 5px;
        cursor: pointer;
        transition: all 0.3s;
    }

    .donation-options input[type="radio"]:checked + span {
        background: #ff8c00;
        color: #fff;
    }

    .custom-amount {
        width: 100%;
        padding: 10px;
        margin-top: 10px;
        border: 1px solid #ccc;
        border-radius: 5px;
        font-size: 16px;
    }

    .frequency {
        display: flex;
        gap: 20px;
        margin-bottom: 20px;
    }

    .frequency label {
        cursor: pointer;
    }

    .form-field {
        margin-bottom: 15px;
    }

    .form-field input {
        width: 100%;
        padding: 10px;
        border: 1px solid #ccc;
        border-radius: 5px;
        font-size: 16px;
    }

    .checkbox {
        margin: 10px 0;
    }

    .submit-btn {
        width: 100%;
        padding: 15px;
        background: #32cd32;
        color: #fff;
        border: none;
        border-radius: 5px;
        font-size: 18px;
        cursor: pointer;
        transition: background 0.3s;
    }

    .submit-btn:hover {
        background: #228b22;
    }

    .impact-section {
        margin-top: 40px;
        text-align: center;
    }

    .impact-grid {
        display: flex;
        justify-content: space-between;
        flex-wrap: wrap;
        gap: 20px;
        margin-top: 20px;
    }

    .impact-item {
        flex: 1;
        min-width: 150px;
        padding: 15px;
        background: #f0f8ff;
        border-radius: 5px;
    }

    .impact-item strong {
        color: #ff8c00;
    }

    @media (max-width: 480px) {
        .donation-options label {
            flex: 1 1 45%;
        }

        .impact-item {
            flex: 1 1 100%;
        }
    }
</style>
