<?php
// When ContentBlocks, plugin => null
// $pluginOption = ($pluginName === 'ContentBlocks') ? ['plugin' => null] : []; // Default to empty array
$websiteTitle = strip_tags($this->ContentBlock->text('website-name'));

?>

<header id="header" class="header d-flex align-items-center sticky-top">
    <div
        class="header-container container-fluid container-xl position-relative d-flex align-items-center justify-content-between">
        <a href="<?= $this->Url->build('/', ['fullBase' => true]); ?>"
           class="logo d-flex align-items-center me-auto me-xl-0">

            <!-- Uncomment the line below if you also wish to use an image logo -->
            <?= $this->ContentBlock->image('website-logo', ['alt' => 'website-logo', 'width' => '30', 'height' => 'auto']) ?>
            <h1 class="sitename">
                <?= strip_tags($this->ContentBlock->text('website-name')); ?>
            </h1>

        </a>

        <nav id="navmenu" class="navmenu">
            <ul>
                <li><a href="<?= $this->Url->build('/#hero') ?>" class="active">Home</a></li>
                <li><a href="<?= $this->Url->build('/#about') ?>">About</a></li>
                <li><a href="<?= $this->Url->build('/#portfolio') ?>">Portfolio</a></li>
                <li><a href="<?= $this->Url->build('/#services') ?>">Services</a></li>
                <li><a href="#contact">Contact</a></li>

                <?php
                $user = $this->request->getAttribute('identity');
                ?>
                <li class="dropdown"><a href="#"><span>Registration</span> <i
                            class="bi bi-chevron-down toggle-dropdown"></i></a>
                    <ul>
                        <li><a href="<?= $this->Url->build('/volunteer-register') ?>">Volunteer Registration</a>
                        </li>
                        <li><a href="<?= $this->Url->build('/student-register') ?>">Student Registration</a></li>
                    </ul>
                </li>

                <?php if ($user): ?>
                    <!-- Show login button for non-logged in users -->
                    <a href="<?= $this->Url->build('/programs') ?>" class="btn-getstarted">Dashboard</a>
                <?php else: ?>
                    <!-- For logged in users, show logout button -->
                      <?php endif; ?>

                <?php if (!$user): ?>
                    <!-- Show login button for non-logged in users -->
                    <a href="<?= $this->Url->build('/auth/login') ?>" class="btn-getstarted">Log in</a>
                    <?php else: ?>
                    <!-- For logged in users, show logout button -->
                    <a href="<?= $this->Url->build('/auth/logout') ?>" class="btn-getstarted">Log out</a>
                <?php endif; ?>
<!--                <li><a href="--><?php //= $this->Url->build('/auth/logout', ['fullBase' => true]); ?><!--">Log out</a></li>-->
            </ul>
            <i class="mobile-nav-toggle d-xl-none bi bi-list"></i>
        </nav>

        <div class="header-social-links">
            <a href="https://x.com/stemincubators" class="twitter"><i class="bi bi-twitter-x"></i></a>
            <a href="https://www.facebook.com/people/Stem-Incubators/100066616540456/" class="facebook"><i
                    class="bi bi-facebook"></i></a>
            <a href="https://www.instagram.com/stem.incubators/" class="instagram"><i class="bi bi-instagram"></i></a>
            <a href="https://www.linkedin.com/company/stem-incubators" class="linkedin"><i
                    class="bi bi-linkedin"></i></a>
        </div>

    </div>
</header>
