<?php
/**
 * Reset Password HTML email template for STEM Incubators
 *
 * @var \App\View\AppView $this
 * @var string $email Recipient's email address
 * @var string $nonce Nonce used to reset the password
 */
?>
<div class="content">
    <!-- START CENTERED WHITE CONTAINER -->
    <table role="presentation" class="main">
        <!-- START MAIN CONTENT AREA -->
        <tr>
            <td class="wrapper">
                <table role="presentation" border="0" cellpadding="0" cellspacing="0">
                    <tr>
                        <td>
                            <h3>Reset Your Password</h3>
                            <p>We received a request to reset the password for your <b>STEM Incubators</b> account.</p>
                            <p>If you requested this change, click the button below to reset your password:</p>
                            <table role="presentation" border="0" cellpadding="0" cellspacing="0" class="btn btn-primary">
                                <tbody>
                                <tr>
                                    <td align="left">
                                        <table role="presentation" border="0" cellpadding="0" cellspacing="0">
                                            <tbody>
                                            <tr>
                                                <td>
                                                    <a href="<?= $this->Url->build(['controller' => 'Auth', 'action' => 'resetPassword', $nonce], ['fullBase' => true]) ?>" target="_blank">Reset Password</a>
                                                </td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    </td>
                                </tr>
                                </tbody>
                            </table>

                            <p>If you did not request a password reset, please disregard this email.</p>
                            <p>You can also reset your password using the link below:</p>
                            <p><?= $this->Html->link($this->Url->build(['controller' => 'Auth', 'action' => 'resetPassword', $nonce], ['fullBase' => true])) ?></p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <!-- END MAIN CONTENT AREA -->
    </table>
    <!-- END CENTERED WHITE CONTAINER -->

    <!-- START FOOTER -->
    <div class="footer" style="margin-top: 20px;">
        <table role="presentation" border="0" cellpadding="0" cellspacing="0">
            <tr>
                <td class="content-block">
                    This email was sent to <?= h($email) ?>.<br>
                    If you received this email in error, please disregard it.
                    <br><br>
                    Copyright &copy; <?= date("Y"); ?> STEM Incubators. All rights reserved.<br>
                    Visit our website: <a href="https://www.stemincubators.com.au" target="_blank">www.stemincubators.com.au</a>
                </td>
            </tr>
        </table>
    </div>
    <!-- END FOOTER -->
</div>
