<?php ?>
<!DOCTYPE html>
<html
    lang="en"
    class="light-style layout-menu-fixed"
    dir="ltr"
    data-theme="theme-default"
    data-template="vertical-menu-template-free"
>
<head>
    <?= $this->Html->charset() ?>
    <meta
        name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0"
    />

    <title>Admin Panel | <?= $this->fetch('title') ?></title>

    <meta name="description" content=""/>

    <!-- Favicon -->
    <?= $this->Html->meta('icon') ?>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com"/>
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin/>
    <link
        href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
        rel="stylesheet"
    />

    <!-- Icons -->
    <?= $this->Html->css('/assets/vendor/fonts/boxicons.css') ?>


    <!-- Core CSS -->
    <?= $this->Html->css([
        '/assets/vendor/css/core.css',
        '/assets/vendor/css/theme-default.css',
        '/assets/vendor/css/demo.css',
        '/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css'
    ]) ?>

    <!-- Helpers -->
    <?= $this->Html->script([
        '/assets/vendor/js/helpers.js',
        '/assets/js/config.js'
    ]) ?>
</head>

<body>
<!-- Layout wrapper -->
<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">
        <!-- Menu -->
        <aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">
            <div class="app-brand demo">
                <a href="<?= $this->Url->build(['controller' => 'Pages', 'action' => 'display', 'plugin' => false]) ?>"
                   class="app-brand-link">
                    <span class="app-brand-text   fw-bolder ms-2" style="font-size: 1.45rem;">Dashboard</span>
                </a>

                <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto d-block d-xl-none">
                    <i class="bx bx-chevron-left bx-sm align-middle"></i>
                </a>
            </div>

            <div class="menu-inner-shadow"></div>

            <ul class="menu-inner py-1">

                <li class="menu-item">
                    <a href="<?= $this->Url->build(['controller' => 'Pages', 'action' => 'display', 'home']); ?>" class="menu-link">
                        <i class="menu-icon tf-icons bx bx-home-circle"></i>
                        <div data-i18n="Analytics">Home</div>
                    </a>
                </li>

                <!-- Programs Section -->
                <li class="menu-item <?= in_array($this->request->getParam('controller'), ['Programs', 'ProgramImages']) ? 'active open' : '' ?>">
                    <a href="javascript:void(0);" class="menu-link menu-toggle">
                        <i class="menu-icon tf-icons  bx bx-collection"></i>
                        <div data-i18n="Layouts">Programs</div>
                    </a>

                    <ul class="menu-sub">
                        <li class="menu-item <?= $this->request->getParam('controller') === 'Programs' && $this->request->getParam('action') === 'index' ? 'active' : '' ?>">
                            <a href="<?= $this->Url->build(['controller' => 'Programs', 'action' => 'index']) ?>"
                               class="menu-link">
                                <div data-i18n="Programs Index">Programs</div>
                            </a>
                        </li>

                        <li class="menu-item <?= $this->request->getParam('controller') === 'Programs' && $this->request->getParam('action') === 'index' ? 'active' : '' ?>">
                            <a href="<?= $this->Url->build(['controller' => 'ProgramStatuses', 'action' => 'index']) ?>"
                               class="menu-link">
                                <div data-i18n="Programs Index">Program Status</div>
                            </a>
                        </li>

                    </ul>
                </li>

                <li class="menu-item <?= in_array($this->request->getParam('controller'), ['Volunteers', 'VolunteerStatuses']) ? 'active open' : '' ?>">
                    <a href="javascript:void(0);" class="menu-link menu-toggle">
                        <i class="menu-icon tf-icons bx bx-user"></i>
                        <div data-i18n="Layouts">Volunteers</div>
                    </a>

                    <ul class="menu-sub">
                        <li class="menu-item <?= $this->request->getParam('controller') === 'Volunteers' && $this->request->getParam('action') === 'index' ? 'active' : '' ?>">
                            <a href="<?= $this->Url->build(['controller' => 'Volunteers', 'action' => 'index']) ?>"
                               class="menu-link">
                                <div data-i18n="Volunteer Index">Volunteer</div>
                            </a>
                        </li>

                        <li class="menu-item <?= $this->request->getParam('controller') === 'VolunteerStatuses' && $this->request->getParam('action') === 'index' ? 'active' : '' ?>">
                            <a href="<?= $this->Url->build(['controller' => 'VolunteerStatuses', 'action' => 'index']) ?>"
                               class="menu-link">
                                <div data-i18n="Volunteer Index">Volunteer Status</div>
                            </a>
                        </li>
                    </ul>
                </li>


                <!-- Students Section -->
                <li class="menu-item <?= in_array($this->request->getParam('controller'), ['Students']) ? 'active open' : '' ?>">
                    <a href="javascript:void(0);" class="menu-link menu-toggle">
                        <i class="menu-icon tf-icons bx bx-user"></i>
                        <div data-i18n="Layouts">Students</div>
                    </a>

                    <ul class="menu-sub">
                        <li class="menu-item <?= $this->request->getParam('controller') === 'Students' && $this->request->getParam('action') === 'index' ? 'active' : '' ?>">
                            <a href="<?= $this->Url->build(['controller' => 'Students', 'action' => 'index']) ?>"
                               class="menu-link">
                                <div data-i18n="Student Index">Student</div>
                            </a>
                        </li>

                        <li class="menu-item <?= $this->request->getParam('controller') === 'Students' && $this->request->getParam('action') === 'add' ? 'active' : '' ?>">
                            <a href="<?= $this->Url->build(['controller' => 'Students', 'action' => 'add']) ?>"
                               class="menu-link">
                                <div data-i18n="Student Add">Add Student</div>
                            </a>
                        </li>
                    </ul>
                </li>

                <li class="menu-item <?= $this->request->getParam('controller') === 'Faqs' ? 'active' : '' ?>">
    <a href="<?= $this->Url->build(['controller' => 'Faqs', 'action' => 'index']) ?>" class="menu-link">
        <i class="menu-icon tf-icons bx bx-question-mark"></i>
        <div data-i18n="FAQ">FAQ</div>
    </a>
</li>


                <li class="menu-item">
                     <?= $this->Html->link('<i class="menu-icon tf-icons bx bx-cog"></i><div data-i18n="CMS">CMS</div>',
                     ['plugin' => 'ContentBlocks', 'controller' => 'ContentBlocks', 'action' => 'index'],
                     ['escape' => false, 'class' => 'menu-link']) ?>
                </li>

                <li class="menu-item">
                    <a href="<?= $this->Url->build(['controller' => 'Auth', 'action' => 'logout']); ?>" class="menu-link">
                        <i class="menu-icon tf-icons bx bx-log-out"></i>
                        <div data-i18n="Analytics">Logout</div>
                    </a>
                </li>
                
            </ul>
        </aside>


        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
            <!-- Navbar -->
            <nav
                class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme"
                id="layout-navbar"
            >
                <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
                    <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                        <i class="bx bx-menu bx-sm"></i>
                    </a>
                </div>

                <div class="navbar-nav-right d-flex " id="navbar-collapse"
                     style="background-color: transparent;">
                    <!-- Search -->
                    <div class="navbar-nav align-items-center" style="background-color: transparent;">
                        <div class="nav-item d-flex align-items-center" style="background-color: transparent;">
                            <!--                            <i class="bx bx-search fs-4 lh-0"></i>-->
                            <!--                            <input-->
                            <!--                                type="text"-->
                            <!--                                class="form-control border-0 shadow-none"-->
                            <!--                                placeholder="Search..."-->
                            <!--                                aria-label="Search..."-->
                            <!--                            />-->
                            <h4 class="m-0 fw-bold text-center" style="color: #e87532;">Welcome To Admin Dashboard</h4>
                        </div>
                    </div>

                </div>

            </nav>
            <!-- / Navbar -->

            <!-- Content wrapper -->
            <div class="content-wrapper">
                <!-- Content -->
                <div class="container-xxl flex-grow-1 container-p-y">
                    <!-- Flash Messages -->
                    <?= $this->Flash->render() ?>

                    <!-- Main Content -->
                    <?= $this->fetch('content') ?>
                </div>
                <!-- / Content -->

                <div class="content-backdrop fade"></div>
            </div>
            <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
    </div>

    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>
</div>
<!-- / Layout wrapper -->

<!-- Core JS -->
<?= $this->Html->script([
    '/assets/vendor/libs/jquery/jquery.js',
    '/assets/vendor/libs/popper/popper.js',
    '/assets/vendor/js/bootstrap.js',
    '/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js',
    '/assets/vendor/js/menu.js',
    '/js/main1.js'
]) ?>

<!-- Page JS -->
<?= $this->fetch('script') ?>

<!-- Place this tag in your head or just before your close body tag. -->
<script async defer src="https://buttons.github.io/buttons.js"></script>
</body>
</html>
